package com.feingto.iot.server.quartz;

import com.feingto.iot.server.config.ElasticSearchAutoConfiguration;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 创建索引定时任务
 */
@Component
public class IndicesSchedulerJob {
    @Resource
    private TransportClient client;

    @Scheduled(cron = "0 0 0,8,16 * * ?")
    public void fixedRateJob() {
        String spanIndexName = ElasticSearchAutoConfiguration.getSpanIndexName();
        if (!client.admin().indices()
                .exists(new IndicesExistsRequest(spanIndexName)).actionGet()
                .isExists()) {
            // 创建索引结构
            client.admin().indices()
                    .prepareCreate(spanIndexName)
                    .execute().actionGet();
            try {
                client.admin().indices()
                        .putMapping(Requests.putMappingRequest(spanIndexName).type("mqtt")
                                .source(ElasticSearchAutoConfiguration.builder())).actionGet();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
