package com.feingto.iot.server.service;

import com.feingto.iot.common.service.IAuth;
import com.feingto.iot.server.config.properties.NettyProperties;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * MQTT 认证服务
 *
 * @author longfei
 */
@Service
public class AuthService implements IAuth {
    @Resource
    private NettyProperties config;

    @Override
    public boolean authorized(String username, byte[] password) {
        return new EqualsBuilder().append(config.getKeyStorePassword().getBytes(), password).isEquals();
    }
}
