package com.feingto.iot.server.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.crypto.SecureUtil;

import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.time.LocalDateTime;

/**
 * 生成RSA私钥
 *
 * @author longfei
 */
public class GenerateRsaKey {
    public static void main(String[] args) {
        String path = "/Users/longfei/Projects/feingto-iot-hub/iot-hub-server/src/main/resources/iot-hub.p12";
        KeyPair keyPair = SecureUtil.generateKeyPair("RSA", 512, LocalDateTime.now().toString().getBytes());
        IoUtil.writeObjects(FileUtil.getOutputStream(path), true, (RSAPrivateKey) keyPair.getPrivate());
        System.out.println("classpath:iot-hub.p12");
    }
}
