package com.feingto.iot.server.util;

import com.feingto.iot.server.bootstrap.IoTServerBootstrap;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;

import javax.net.ssl.KeyManagerFactory;
import java.io.InputStream;
import java.security.KeyStore;

/**
 * SslContext 加载器
 *
 * @author longfei
 */
public class SslContextLoader {
    public static SslContext initialize(String keyPath, String password) {
        try (InputStream is = IoTServerBootstrap.class.getResourceAsStream(keyPath)) {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(is, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password.toCharArray());
            return SslContextBuilder.forServer(kmf).build();
        } catch (Exception e) {
            throw new Error("Failed to initialize ssl context", e);
        }
    }
}
