/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.bootstrap;

import com.feingto.iot.common.handler.MessageHandler;
import com.feingto.iot.server.handler.BaseMessageHandler;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ConditionalOnBean(value={MessageHandler.class})
public class HandlerContext
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(HandlerContext.class);
    private static BaseMessageHandler handler;

    public static BaseMessageHandler getHandler() {
        return handler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Optional.of(applicationContext.getBeansOfType(MessageHandler.class)).ifPresent(map -> HandlerContext.initHandler(map.values()));
    }

    private static void initHandler(Collection<MessageHandler> beans) {
        log.info("{} handlers have been detected", (Object)beans.size());
        AtomicInteger latch = new AtomicInteger(0);
        beans.stream().filter(bean -> BaseMessageHandler.class.isAssignableFrom(bean.getClass())).forEach(bean -> {
            log.info("Registering handler with {}", (Object)bean.getClass().getSimpleName());
            try {
                BaseMessageHandler baseMessageHandler = (BaseMessageHandler)bean;
                if (latch.get() == 0) {
                    handler = baseMessageHandler;
                }
                handler.filter(baseMessageHandler);
                latch.getAndIncrement();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

