/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.bootstrap;

import com.feingto.iot.common.bootstrap.SimpleHandlerLoader;
import com.feingto.iot.common.model.enums.Protocol;
import com.feingto.iot.server.bootstrap.IoTServerBootstrap;
import com.feingto.iot.server.config.properties.NettyProperties;
import com.feingto.iot.server.handler.HttpRequestHandler;
import com.feingto.iot.server.handler.MqttMessageHandler;
import com.feingto.iot.server.handler.TcpMessageHandler;
import com.feingto.iot.server.handler.WebSocketMessageHandler;
import com.feingto.iot.server.service.PushService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTServerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(IoTServerBootstrap.class);
    private Protocol protocol;
    private int port;
    private NettyProperties config;

    public void run() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.config.getBossThread(), (ThreadFactory)new DefaultThreadFactory("BOSS_"));
        NioEventLoopGroup workGroup = new NioEventLoopGroup(this.config.getWorkThread(), (ThreadFactory)new DefaultThreadFactory("WORK_"));
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)this.config.getBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.config.isKeepalive()).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */);
            Channel channel = bootstrap.bind(this.port).sync().channel();
            switch (2.$SwitchMap$com$feingto$iot$common$model$enums$Protocol[this.protocol.ordinal()]) {
                case 1: {
                    log.info("[{}] Accepting connections at: {}", (Object)this.protocol, (Object)("tcp://0.0.0.0:" + this.port));
                    break;
                }
                case 2: {
                    log.info("[{}] Accepting connections at: {}", (Object)this.protocol, (Object)("ws://0.0.0.0:" + this.port + "/websocket"));
                    break;
                }
                case 3: {
                    log.info("[{}] Accepting connections at: {}", (Object)this.protocol, (Object)("tcp://0.0.0.0:" + this.port));
                    break;
                }
                case 4: {
                    log.info("[{}] Accepting connections at: {}", (Object)this.protocol, (Object)("ws://0.0.0.0:" + this.port + "/mqtt"));
                }
            }
            channel.closeFuture().sync();
        }
        catch (Exception e) {
            log.error("IoT [{}] server exception: {}", (Object)this.protocol, (Object)e.getMessage());
            throw new RuntimeException(e.getCause());
        }
        finally {
            log.info("IoT [{}] server closing...", (Object)this.protocol);
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
        }
    }

    private void intProtocolHandler(ChannelPipeline channelPipeline) {
        PushService pushService = new PushService();
        switch (2.$SwitchMap$com$feingto$iot$common$model$enums$Protocol[this.protocol.ordinal()]) {
            case 1: {
                SimpleHandlerLoader.getTcpHandlers().forEach(xva$0 -> channelPipeline.addLast(new ChannelHandler[]{xva$0}));
                channelPipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)this.config.getMqtt().getTimeout(), 0L, 0L, TimeUnit.SECONDS)});
                channelPipeline.addLast(new ChannelHandler[]{new TcpMessageHandler()});
                break;
            }
            case 2: {
                SimpleHandlerLoader.getHttpChannelHandlers().forEach(xva$0 -> channelPipeline.addLast(new ChannelHandler[]{xva$0}));
                channelPipeline.addLast(new ChannelHandler[]{new WebSocketMessageHandler()});
                channelPipeline.addLast(new ChannelHandler[]{new HttpRequestHandler()});
                break;
            }
            case 3: {
                SimpleHandlerLoader.getMqttChannelHandlers().forEach(xva$0 -> channelPipeline.addLast(new ChannelHandler[]{xva$0}));
                channelPipeline.addLast(new ChannelHandler[]{new MqttMessageHandler(pushService)});
                break;
            }
            case 4: {
                SimpleHandlerLoader.getMqttWsChannelHandlers().forEach(xva$0 -> channelPipeline.addLast(new ChannelHandler[]{xva$0}));
                channelPipeline.addLast(new ChannelHandler[]{new MqttMessageHandler(pushService)});
            }
        }
    }

    public IoTServerBootstrap protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public IoTServerBootstrap port(int port) {
        this.port = port;
        return this;
    }

    public IoTServerBootstrap config(NettyProperties config) {
        this.config = config;
        return this;
    }

    static /* synthetic */ NettyProperties access$000(IoTServerBootstrap x0) {
        return x0.config;
    }

    static /* synthetic */ void access$100(IoTServerBootstrap x0, ChannelPipeline x1) {
        x0.intProtocolHandler(x1);
    }
}

