/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SessionStore;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class SessionCache {
    private static SessionCache instance;
    private static ConcurrentHashMap<String, SessionStore> sessionMap;

    public static SessionCache getInstance() {
        if (instance == null) {
            instance = new SessionCache();
        }
        return instance;
    }

    public SessionStore get(String clientId) {
        return (SessionStore)sessionMap.get(clientId);
    }

    public void put(String clientId, SessionStore message) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        sessionMap.put(clientId, message);
    }

    public void remove(String clientId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        sessionMap.remove(clientId);
    }

    static {
        sessionMap = new ConcurrentHashMap();
    }
}

