/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.config;

import com.feingto.iot.server.config.properties.ElasticSearchProperties;
import java.io.IOException;
import java.net.InetAddress;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class ElasticSearchAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchAutoConfiguration.class);

    @Bean
    public String spanIndexName() {
        return ElasticSearchAutoConfiguration.getSpanIndexName();
    }

    @Bean(value={"elasticSearchProperties"})
    public ElasticSearchProperties config() {
        return new ElasticSearchProperties();
    }

    @Bean
    public TransportClient transportClient() {
        PreBuiltTransportClient client = new PreBuiltTransportClient(Settings.builder().put("cluster.name", this.config().getClusterName()).build(), new Class[0]);
        log.info("Elasticsearch cluster nodes: [{}]", (Object)this.config().getClusterNodes());
        String[] clusterNodes = this.config().getClusterNodes().split(",", -1);
        try {
            for (String str : clusterNodes) {
                String[] node = str.split(":");
                client.addTransportAddress(new TransportAddress(InetAddress.getByName(node[0]), Integer.valueOf(node[1]).intValue()));
            }
            if (!((IndicesExistsResponse)client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.spanIndexName()})).actionGet()).isExists()) {
                client.admin().indices().prepareCreate(this.spanIndexName()).execute().actionGet();
                client.admin().indices().putMapping(Requests.putMappingRequest((String[])new String[]{this.spanIndexName()}).type("mqtt").source(ElasticSearchAutoConfiguration.builder())).actionGet();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return client;
    }

    public static String getSpanIndexName() {
        return "im:span:" + new DateTime(DateTimeZone.UTC).toString("yyyy-MM-dd");
    }

    public static XContentBuilder builder() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("mqtt").startObject("properties").startObject("from").field("type", "keyword").endObject().startObject("to").field("type", "keyword").endObject().startObject("topic").field("type", "keyword").endObject().startObject("payload").field("type", "keyword").endObject().startObject("status").field("type", "keyword").endObject().startObject("timestamp").field("type", "date").endObject().endObject().endObject().endObject();
    }
}

