/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.MessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseMessageHandler.class);
    private MqttMessageType type;
    private List<BaseMessageHandler> filters = new ArrayList();

    public BaseMessageHandler(MqttMessageType type) {
        this.type = type;
    }

    public BaseMessageHandler filter(BaseMessageHandler filter) {
        this.filters.add(filter);
        return this;
    }

    public void proceed(MqttMessageType type, Channel channel, Object object) {
        if (this.type.equals((Object)type)) {
            log.debug(">>> message type: {}", (Object)type);
            this.handle(channel, object);
            return;
        }
        this.filters.stream().filter(Objects::nonNull).filter((? super T filter) -> type.equals((Object)filter.type)).findFirst().ifPresent(filter -> filter.proceed(type, channel, object));
    }
}

