/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.DefaultSimpleChannelHandler;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SessionStore;
import com.feingto.iot.server.bootstrap.HandlerContext;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.service.PushService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MqttMessageHandler
extends DefaultSimpleChannelHandler<MqttMessage> {
    private static final Logger log = LoggerFactory.getLogger(MqttMessageHandler.class);
    private final PushService pushService;

    public MqttMessageHandler(PushService pushService) {
        this.pushService = pushService;
    }

    public void handleMessage(ChannelHandlerContext ctx, MqttMessage msg) {
        MqttFixedHeader header = msg.fixedHeader();
        if (header == null) {
            return;
        }
        HandlerContext.getHandler().proceed(header.messageType(), ctx.channel(), (Object)msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.ALL_IDLE) {
                String clientId = (String)ctx.channel().attr(AttributeKey.valueOf((String)"clientId")).get();
                Optional.ofNullable(SessionCache.getInstance().get(clientId)).filter(sess -> sess.willMessage() != null).map(SessionStore::willMessage).ifPresent(msg -> {
                    log.debug(">>> publish will message to {}", (Object)clientId);
                    this.pushService.internalSend(SendMessage.newInstance((MqttPublishMessage)msg));
                });
                ctx.close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

