/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.DefaultChannelInboundHandler;
import com.feingto.iot.common.model.custom.BaseMessage;
import com.feingto.iot.common.model.custom.LoginMessage;
import com.feingto.iot.common.model.custom.Message;
import com.feingto.iot.common.model.custom.MessageChannel;
import com.feingto.iot.common.model.custom.SystemMessage;
import com.feingto.iot.common.model.enums.MessageType;
import com.feingto.iot.server.cache.ChannelCache;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TcpMessageHandler
extends DefaultChannelInboundHandler {
    private static final Logger log = LoggerFactory.getLogger(TcpMessageHandler.class);
    private static AtomicReference<Map<ChannelId, Integer>> lossCounters = new AtomicReference();

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ChannelCache.getInstance().remove(ctx.channel().id().asLongText());
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ChannelHandlerContext ctx, Object msg) {
        lossCounters.updateAndGet(map -> {
            map = (Map)((Object)Maps.newHashMap().put(ctx.channel().id(), 0));
            return map;
        });
        byte protocol = ((BaseMessage)msg).protocol();
        try {
            if (protocol == MessageType.LOGIN.getValue()) {
                LoginMessage message = (LoginMessage)msg;
                log.debug(">>> login username: {}", (Object)message.username());
                ChannelCache.getInstance().put(ctx.channel().id().asLongText(), new MessageChannel().channel(ctx.channel()).username(message.username()));
                ctx.channel().writeAndFlush((Object)message.protocol(MessageType.LOGIN_RESPONSE.getValue()));
            } else {
                MessageChannel mqttChannel = ChannelCache.getInstance().get(ctx.channel().id().asLongText());
                if (mqttChannel == null) {
                    log.debug("\u5ba2\u6237\u7aef\u672a\u767b\u5f55");
                    return;
                }
                if (protocol == MessageType.SYSTEM.getValue()) {
                    ChannelCache.getInstance().push((Message)((SystemMessage)msg));
                } else if (protocol == MessageType.MESSAGE.getValue()) {
                    ctx.channel().writeAndFlush((Object)((Message)msg).protocol(MessageType.MESSAGE_RESPONSE.getValue()));
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                log.debug(">>> server reader idle");
                ChannelId channelId = ctx.channel().id();
                lossCounters.updateAndGet(map -> {
                    map = (Map)((Object)Maps.newHashMap().put(channelId, (Integer)((Map)lossCounters.get()).get(channelId) + 1));
                    return map;
                });
                if ((Integer)((Map)lossCounters.get()).get(channelId) > 2) {
                    log.debug(">>> closed channel id: {}", (Object)ctx.channel().id());
                    ChannelCache.getInstance().remove(ctx.channel().id().asLongText());
                    ctx.channel().close();
                }
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

