/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.cache.SubscribeCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ignite.IgniteCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DisconnectHandler
extends BaseMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DisconnectHandler.class);
    @Resource(name="igniteSubscribe")
    private IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> igniteSubscribe;
    @Resource(name="igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public DisconnectHandler() {
        super(MqttMessageType.DISCONNECT);
    }

    public void handle(Channel channel, Object object) {
        String clientId = (String)channel.attr(Constants.KEY_CLIENT_ID).get();
        Optional.ofNullable(SessionCache.getInstance().get(clientId)).ifPresent(sess -> {
            if (sess.willMessage() != null) {
                log.debug(">>> remove will message of the {}", (Object)clientId);
                sess.willMessage(null);
            }
            if (sess.cleanSession()) {
                log.debug(">>> clean session of the {}", (Object)clientId);
                SessionCache.getInstance().remove(clientId);
                SubscribeCache.getInstance((IgniteCache)this.igniteSubscribe).remove(clientId);
                MessageCache.getInstance((IgniteCache)this.igniteMessage).remove(clientId);
            }
            SessionCache.getInstance().remove(clientId);
        });
        channel.close();
    }
}

