/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

@Component
public class PubackHandler
extends BaseMessageHandler {
    @Resource(name="igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubackHandler() {
        super(MqttMessageType.PUBACK);
    }

    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage)object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        MessageCache.getInstance((IgniteCache)this.igniteMessage).remove((String)channel.attr(Constants.KEY_CLIENT_ID).get(), Integer.valueOf(variableHeader.messageId()));
    }
}

