/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

@Component
public class PubrecHandler
extends BaseMessageHandler {
    @Resource(name="igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubrecHandler() {
        super(MqttMessageType.PUBREC);
    }

    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage)object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        int messageId = variableHeader.messageId();
        Optional.ofNullable(MessageCache.getInstance((IgniteCache)this.igniteMessage).get((String)channel.attr(Constants.KEY_CLIENT_ID).get(), Integer.valueOf(messageId))).ifPresent(message -> message.type(MqttMessageType.PUBREL));
        MessageResponse.pubrel((Channel)channel, (int)messageId);
    }
}

