/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageRequest;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ignite.IgniteCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PubrelHandler
extends BaseMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(PubrelHandler.class);
    @Resource(name="igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubrelHandler() {
        super(MqttMessageType.PUBREL);
    }

    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage)object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        int messageId = variableHeader.messageId();
        Optional.ofNullable(MessageCache.getInstance((IgniteCache)this.igniteMessage).findByMessageId(Integer.valueOf(messageId))).ifPresent(messages -> messages.forEach(map -> map.keySet().forEach(key -> Optional.ofNullable(SessionCache.getInstance().get(key)).ifPresent(sess -> {
            log.debug(">>> send to {} with topic {}", key, (Object)((SendMessage)map.get(key)).topic());
            MessageRequest.publish((Channel)sess.channel(), (SendMessage)((SendMessage)map.get(key)));
            MessageCache.getInstance((IgniteCache)this.igniteMessage).remove(key, Integer.valueOf(messageId));
        }))));
        MessageResponse.pubcomp((Channel)channel, (int)messageId);
    }
}

