/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.SubscribeCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

@Component
public class UnSubscribeHandler
extends BaseMessageHandler {
    @Resource(name="igniteSubscribe")
    private IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> igniteSubscribe;

    public UnSubscribeHandler() {
        super(MqttMessageType.UNSUBSCRIBE);
    }

    public void handle(Channel channel, Object object) {
        MqttUnsubscribeMessage msg = (MqttUnsubscribeMessage)object;
        msg.payload().topics().forEach(topic -> SubscribeCache.getInstance((IgniteCache)this.igniteSubscribe).remove(topic, (String)channel.attr(Constants.KEY_CLIENT_ID).get()));
        MessageResponse.unsuback((Channel)channel, (int)msg.variableHeader().messageId());
    }
}

