/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.quartz;

import com.feingto.iot.server.config.ElasticSearchAutoConfiguration;
import java.io.IOException;
import javax.annotation.Resource;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class IndicesSchedulerJob {
    @Resource
    private TransportClient client;

    @Scheduled(cron="0 0 0,8,16 * * ?")
    public void fixedRateJob() {
        String spanIndexName = ElasticSearchAutoConfiguration.getSpanIndexName();
        if (!((IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{spanIndexName})).actionGet()).isExists()) {
            this.client.admin().indices().prepareCreate(spanIndexName).execute().actionGet();
            try {
                this.client.admin().indices().putMapping(Requests.putMappingRequest((String[])new String[]{spanIndexName}).type("mqtt").source(ElasticSearchAutoConfiguration.builder())).actionGet();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

