/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.util;

import com.feingto.iot.server.bootstrap.IoTServerBootstrap;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;

public class SslContextLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext initialize(String keyPath, String password) {
        try (InputStream is = IoTServerBootstrap.class.getResourceAsStream(keyPath);){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(is, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password.toCharArray());
            SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).build();
            return sslContext;
        }
        catch (Exception e) {
            throw new Error("Failed to initialize ssl context", e);
        }
    }
}

