/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.api.ValidationStatusCode;
import com.feiniaojin.gracefulresponse.data.Response;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;
import jakarta.annotation.Resource;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ControllerAdvice
@Order(value=100)
public class ValidationExceptionAdvice {
    private final Logger logger = LoggerFactory.getLogger(ValidationExceptionAdvice.class);
    @Resource
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Resource
    private ResponseStatusFactory responseStatusFactory;
    @Resource
    private ResponseFactory responseFactory;
    @Resource
    private GracefulResponseProperties gracefulResponseProperties;

    @ExceptionHandler(value={BindException.class, ValidationException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public Response exceptionHandler(Exception e) throws Exception {
        if (e instanceof MethodArgumentNotValidException || e instanceof BindException) {
            ResponseStatus responseStatus = this.handleBindException((BindException)e);
            return this.responseFactory.newInstance(responseStatus);
        }
        if (e instanceof ConstraintViolationException) {
            ResponseStatus responseStatus = this.handleConstraintViolationException(e);
            return this.responseFactory.newInstance(responseStatus);
        }
        return this.responseFactory.newFailInstance();
    }

    private ResponseStatus handleBindException(BindException e) throws Exception {
        String code;
        List allErrors = e.getBindingResult().getAllErrors();
        String msg = allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(";"));
        ValidationStatusCode validateStatusCode = this.findValidationStatusCodeInController();
        if (validateStatusCode != null) {
            String code2 = validateStatusCode.code();
            return this.responseStatusFactory.newInstance(code2, msg);
        }
        List fieldErrors = e.getFieldErrors();
        if (!CollectionUtils.isEmpty((Collection)fieldErrors)) {
            ValidationStatusCode annotation;
            FieldError fieldError = (FieldError)fieldErrors.get(0);
            String fieldName = fieldError.getField();
            Object target = e.getTarget();
            Field field = null;
            Class<?> clazz = null;
            Object obj = target;
            if (fieldName.contains(".")) {
                String[] strings;
                for (String fName : strings = fieldName.split("\\.")) {
                    clazz = obj.getClass();
                    field = obj.getClass().getDeclaredField(fName);
                    field.setAccessible(true);
                    obj = field.get(obj);
                }
            } else {
                clazz = target.getClass();
                field = target.getClass().getDeclaredField(fieldName);
            }
            if ((annotation = field.getAnnotation(ValidationStatusCode.class)) != null) {
                String code3 = annotation.code();
                return this.responseStatusFactory.newInstance(code3, msg);
            }
            annotation = clazz.getAnnotation(ValidationStatusCode.class);
            if (annotation != null) {
                String code4 = annotation.code();
                return this.responseStatusFactory.newInstance(code4, msg);
            }
        }
        if (StringUtils.hasLength((String)(code = this.gracefulResponseProperties.getDefaultValidateErrorCode()))) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.gracefulResponseProperties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private Method currentControllerMethod() throws Exception {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)requestAttributes;
        HandlerExecutionChain handlerChain = this.requestMappingHandlerMapping.getHandler(sra.getRequest());
        assert (handlerChain != null);
        HandlerMethod handler = (HandlerMethod)handlerChain.getHandler();
        return handler.getMethod();
    }

    private ResponseStatus handleConstraintViolationException(Exception e) throws Exception {
        ConstraintViolationException exception = (ConstraintViolationException)e;
        Set violationSet = exception.getConstraintViolations();
        String msg = violationSet.stream().map(s -> s.getConstraintDescriptor().getMessageTemplate()).collect(Collectors.joining(";"));
        ValidationStatusCode validationStatusCode = this.findValidationStatusCodeInController();
        if (validationStatusCode != null) {
            String code = validationStatusCode.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        String code = this.gracefulResponseProperties.getDefaultValidateErrorCode();
        if (StringUtils.hasLength((String)code)) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.gracefulResponseProperties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private ValidationStatusCode findValidationStatusCodeInController() throws Exception {
        Method method = this.currentControllerMethod();
        ValidationStatusCode validateStatusCode = method.getAnnotation(ValidationStatusCode.class);
        if (validateStatusCode == null) {
            validateStatusCode = method.getDeclaringClass().getAnnotation(ValidationStatusCode.class);
        }
        return validateStatusCode;
    }
}

