/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.AfterControllerAdviceProcess;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.BeforeControllerAdviceProcess;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceHttpProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdvicePredicate;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.RejectStrategy;
import com.feiniaojin.gracefulresponse.data.Response;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractControllerAdvice {
    private List<ControllerAdvicePredicate> predicates = new CopyOnWriteArrayList<ControllerAdvicePredicate>();
    private RejectStrategy rejectStrategy;
    private BeforeControllerAdviceProcess beforeControllerAdviceProcess;
    private AfterControllerAdviceProcess afterControllerAdviceProcess;
    private ControllerAdviceProcessor controllerAdviceProcessor;
    private ControllerAdviceHttpProcessor controllerAdviceHttpProcessor;

    public Object exceptionHandler(Exception exception) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        HandlerMethod handler = (HandlerMethod)request.getAttribute(HandlerMethod.class.getName());
        boolean hit = true;
        List<ControllerAdvicePredicate> pList = this.predicates;
        for (ControllerAdvicePredicate predicateBeforeHandle : pList) {
            if (predicateBeforeHandle.shouldApplyTo(request, response, handler, exception)) continue;
            hit = false;
            break;
        }
        if (!hit) {
            return this.rejectStrategy.call(request, response, handler, exception);
        }
        if (Objects.nonNull(this.beforeControllerAdviceProcess)) {
            this.beforeControllerAdviceProcess.call(request, response, handler, exception);
        }
        Response grResponse = this.controllerAdviceProcessor.process(request, response, handler, exception);
        if (Objects.nonNull(this.afterControllerAdviceProcess)) {
            this.afterControllerAdviceProcess.call(grResponse, exception);
        }
        return this.controllerAdviceHttpProcessor.process(grResponse, exception);
    }

    public List<ControllerAdvicePredicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<ControllerAdvicePredicate> predicates) {
        this.predicates = predicates;
    }

    public ControllerAdviceProcessor getControllerAdviceProcessor() {
        return this.controllerAdviceProcessor;
    }

    public void setControllerAdviceProcessor(ControllerAdviceProcessor controllerAdviceProcessor) {
        this.controllerAdviceProcessor = controllerAdviceProcessor;
    }

    public RejectStrategy getRejectStrategy() {
        return this.rejectStrategy;
    }

    public void setRejectStrategy(RejectStrategy rejectStrategy) {
        this.rejectStrategy = rejectStrategy;
    }

    public void setBeforeControllerAdviceProcess(BeforeControllerAdviceProcess beforeControllerAdviceProcess) {
        this.beforeControllerAdviceProcess = beforeControllerAdviceProcess;
    }

    public AfterControllerAdviceProcess getAfterControllerAdviceProcess() {
        return this.afterControllerAdviceProcess;
    }

    public void setAfterControllerAdviceProcess(AfterControllerAdviceProcess afterControllerAdviceProcess) {
        this.afterControllerAdviceProcess = afterControllerAdviceProcess;
    }

    public BeforeControllerAdviceProcess getBeforeControllerAdviceProcess() {
        return this.beforeControllerAdviceProcess;
    }

    public ControllerAdviceHttpProcessor getControllerAdviceHttpProcessor() {
        return this.controllerAdviceHttpProcessor;
    }

    public void setControllerAdviceHttpProcessor(ControllerAdviceHttpProcessor controllerAdviceHttpProcessor) {
        this.controllerAdviceHttpProcessor = controllerAdviceHttpProcessor;
    }
}

