/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.ExceptionAliasRegister;
import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.advice.AbstractControllerAdvice;
import com.feiniaojin.gracefulresponse.advice.AdviceSupport;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceHttpProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdvicePredicate;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceProcessor;
import com.feiniaojin.gracefulresponse.api.ExceptionAliasFor;
import com.feiniaojin.gracefulresponse.api.ExceptionMapper;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.data.ExceptionAliasConfig;
import com.feiniaojin.gracefulresponse.data.Response;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;

@Order(value=200)
@ControllerAdvice
public class DefaultGlobalExceptionAdvice
extends AbstractControllerAdvice
implements ControllerAdvicePredicate,
ControllerAdviceProcessor,
ControllerAdviceHttpProcessor {
    @Resource
    private ExceptionAliasRegister exceptionAliasRegister;
    @Resource
    private ResponseFactory responseFactory;
    @Resource
    private GracefulResponseProperties properties;
    @Resource
    private ResponseStatusFactory responseStatusFactory;
    @Resource
    private AdviceSupport adviceSupport;

    @Override
    public Response process(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception exception) {
        ResponseStatus statusLine = this.fromExceptionInstance(exception);
        return this.responseFactory.newInstance(statusLine);
    }

    private ResponseStatus fromExceptionInstance(Throwable throwable) {
        String throwableMessage;
        ExceptionAliasFor exceptionAliasFor;
        ExceptionAliasConfig exceptionAliasConfig;
        Class<?> clazz = throwable.getClass();
        ExceptionMapper exceptionMapper = clazz.getAnnotation(ExceptionMapper.class);
        if (exceptionMapper != null) {
            String throwableMessage2;
            boolean msgReplaceable = exceptionMapper.msgReplaceable();
            if (msgReplaceable && (throwableMessage2 = throwable.getMessage()) != null) {
                return this.responseStatusFactory.newInstance(exceptionMapper.code(), throwableMessage2);
            }
            return this.responseStatusFactory.newInstance(exceptionMapper.code(), exceptionMapper.msg());
        }
        Map<Class<?>, ExceptionAliasConfig> exceptionAliasConfigMap = this.properties.getExceptionAliasConfigMap();
        if (!CollectionUtils.isEmpty(exceptionAliasConfigMap) && (exceptionAliasConfig = exceptionAliasConfigMap.get(clazz)) != null) {
            return this.responseStatusFactory.newInstance(exceptionAliasConfig.getCode(), exceptionAliasConfig.getMsg());
        }
        if (this.exceptionAliasRegister != null && (exceptionAliasFor = this.exceptionAliasRegister.getExceptionAliasFor(clazz)) != null) {
            return this.responseStatusFactory.newInstance(exceptionAliasFor.code(), exceptionAliasFor.msg());
        }
        ResponseStatus defaultError = this.responseStatusFactory.defaultError();
        if (Boolean.TRUE.equals(this.properties.getOriginExceptionUsingDetailMessage()) && (throwableMessage = throwable.getMessage()) != null) {
            defaultError.setMsg(throwableMessage);
        }
        return defaultError;
    }

    @Override
    @ExceptionHandler(value={Throwable.class})
    public Object exceptionHandler(Exception exception) {
        return super.exceptionHandler(exception);
    }

    @Override
    public boolean shouldApplyTo(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception exception) {
        if (this.adviceSupport.isMatchExcludeException(exception)) {
            RequestContextHolder.currentRequestAttributes().setAttribute("RELEASE_EXCEPTION_KEY", (Object)exception, 0);
            return false;
        }
        return true;
    }

    @Override
    public ResponseEntity<Response> process(Response response, Throwable throwable) {
        HttpStatus httpStatusCode;
        org.springframework.web.bind.annotation.ResponseStatus httpResponseStatus = (org.springframework.web.bind.annotation.ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(throwable.getClass(), org.springframework.web.bind.annotation.ResponseStatus.class);
        if (Objects.nonNull(httpResponseStatus)) {
            httpStatusCode = httpResponseStatus.value();
        } else {
            Map<Class<?>, ExceptionAliasConfig> exceptionAliasConfigMap = this.properties.getExceptionAliasConfigMap();
            Class<?> aClass = throwable.getClass();
            if (!CollectionUtils.isEmpty(exceptionAliasConfigMap) && Objects.nonNull(exceptionAliasConfigMap.get(aClass)) && Objects.nonNull(exceptionAliasConfigMap.get(aClass).getHttpStatusCode())) {
                httpStatusCode = HttpStatus.valueOf((int)exceptionAliasConfigMap.get(aClass).getHttpStatusCode());
            } else {
                ExceptionAliasFor exceptionAliasFor = this.exceptionAliasRegister.getExceptionAliasFor(throwable.getClass());
                if (exceptionAliasFor != null && exceptionAliasFor.httpStatusCode() > 0) {
                    httpStatusCode = HttpStatus.valueOf((int)exceptionAliasFor.httpStatusCode());
                } else {
                    Integer defaultHttpStatusCodeOnError = this.properties.getDefaultHttpStatusCodeOnError();
                    httpStatusCode = HttpStatus.valueOf((int)defaultHttpStatusCodeOnError);
                }
            }
        }
        return new ResponseEntity((Object)response, httpStatusCode);
    }
}

