/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseRejectException;
import com.feiniaojin.gracefulresponse.advice.AbstractControllerAdvice;
import com.feiniaojin.gracefulresponse.advice.AdviceSupport;
import com.feiniaojin.gracefulresponse.advice.ExceptionHandlerModel;
import com.feiniaojin.gracefulresponse.advice.ReleaseExceptionHandlerExceptionResolver;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.RejectStrategy;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.HandlerMethod;

public class DefaultRejectStrategyImpl
implements RejectStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRejectStrategyImpl.class);
    private Set<ExceptionHandlerModel> set = new CopyOnWriteArraySet<ExceptionHandlerModel>();
    @Resource
    private AdviceSupport adviceSupport;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ReleaseExceptionHandlerExceptionResolver releaseExceptionHandlerExceptionResolver;

    @Override
    public Object call(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception exception) {
        if (this.adviceSupport.isMatchExcludeException(exception)) {
            Optional<HandlerMethod> handlerMethod;
            LOGGER.debug("\u5bfb\u627e\u662f\u5426\u6709Graceful Response\u4e4b\u5916\u7684\u5f02\u5e38\u5904\u7406\u5668", (Throwable)exception);
            if (!this.set.isEmpty() && (handlerMethod = this.findHandlerMethod(exception)).isPresent()) {
                return this.releaseExceptionHandlerExceptionResolver.doResolveHandlerMethodException(request, response, handlerMethod.get(), exception);
            }
        }
        throw new GracefulResponseRejectException("\u5f02\u5e38\u4e0d\u5339\u914d\uff0c\u7531ErrorController\u8fdb\u884c\u9519\u8bef\u5904\u7406", (Throwable)exception);
    }

    @PostConstruct
    public void collectAllExceptionHandlers() {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(ControllerAdvice.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            Method[] methods;
            Object object = entry.getValue();
            if (object instanceof AbstractControllerAdvice) continue;
            for (Method method : methods = object.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ExceptionHandler.class)) continue;
                LOGGER.debug("className={},methodName={}", (Object)object.getClass().getName(), (Object)method.getName());
                this.set.add(new ExceptionHandlerModel(method, object));
            }
        }
    }

    private Optional<HandlerMethod> findHandlerMethod(Exception exception) {
        Class<?> throwableClass = exception.getClass();
        Optional<ExceptionHandlerModel> modelOptional = this.set.stream().filter(model -> {
            Method method = model.getMethod();
            ExceptionHandler exceptionHandler = method.getAnnotation(ExceptionHandler.class);
            Class[] classes = exceptionHandler.value();
            return Arrays.stream(classes).anyMatch(clazz -> clazz.isAssignableFrom(throwableClass));
        }).findFirst();
        if (!modelOptional.isPresent()) {
            return Optional.empty();
        }
        ExceptionHandlerModel model2 = modelOptional.get();
        return Optional.of(new HandlerMethod(model2.getBean(), model2.getMethod()));
    }
}

