/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseException;
import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.advice.AbstractControllerAdvice;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceHttpProcessor;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdvicePredicate;
import com.feiniaojin.gracefulresponse.advice.lifecycle.exception.ControllerAdviceProcessor;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.api.ValidationStatusCode;
import com.feiniaojin.gracefulresponse.data.Response;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Order(value=100)
@ControllerAdvice
public class DefaultValidationExceptionAdvice
extends AbstractControllerAdvice
implements ControllerAdvicePredicate,
ControllerAdviceProcessor,
ControllerAdviceHttpProcessor {
    private final Logger logger = LoggerFactory.getLogger(DefaultValidationExceptionAdvice.class);
    private static final String VALIDATION_STATUS_CODE = "ValidationStatusCode";
    private static final String PACKAGE_SEP = ".";
    @Resource
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Resource
    private ResponseFactory responseFactory;
    @Resource
    private GracefulResponseProperties properties;
    @Resource
    private ResponseStatusFactory responseStatusFactory;
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    @Override
    public Response process(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        BindException exception;
        ResponseStatus responseStatus = null;
        if (ex instanceof BindException) {
            exception = (BindException)ex;
            responseStatus = this.handleBindException(exception);
        } else if (ex instanceof ConstraintViolationException) {
            exception = (ConstraintViolationException)ex;
            responseStatus = this.handleConstraintViolationException((Exception)exception);
        }
        Response grRresponse = Objects.nonNull(responseStatus) ? this.responseFactory.newInstance(responseStatus) : this.responseFactory.newFailInstance();
        return grRresponse;
    }

    @Override
    @ExceptionHandler(value={BindException.class, ValidationException.class, MethodArgumentNotValidException.class})
    public Object exceptionHandler(Exception exception) {
        return super.exceptionHandler(exception);
    }

    private ResponseStatus handleBindException(BindException e) {
        String code;
        BindingResult bindingResult = e.getBindingResult();
        List allErrors = bindingResult.getAllErrors();
        String msg = allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(";"));
        ValidationStatusCode validateStatusCode = this.findValidationStatusCode(e);
        if (Objects.nonNull(validateStatusCode)) {
            RequestContextHolder.currentRequestAttributes().setAttribute(VALIDATION_STATUS_CODE, (Object)validateStatusCode, 0);
            code = validateStatusCode.code();
            if (StringUtils.hasLength((String)code)) {
                return this.responseStatusFactory.newInstance(code, msg);
            }
        }
        if (StringUtils.hasLength((String)(code = this.properties.getDefaultValidateErrorCode()))) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.properties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private ValidationStatusCode findValidationStatusCode(BindException e) {
        ValidationStatusCode validateStatusCode = this.findValidationStatusCodeInController();
        if (Objects.nonNull(validateStatusCode)) {
            return validateStatusCode;
        }
        BindingResult bindingResult = e.getBindingResult();
        List fieldErrors = e.getFieldErrors();
        if (fieldErrors.isEmpty()) {
            return null;
        }
        FieldError fieldError = (FieldError)fieldErrors.get(0);
        String fieldName = fieldError.getField();
        Field field = null;
        Class<?> clazz = null;
        Object target = bindingResult.getTarget();
        if (Objects.isNull(target)) {
            return null;
        }
        if (!fieldName.contains(PACKAGE_SEP)) {
            clazz = target.getClass();
        } else {
            String fieldParentPath = this.fieldParentPath(fieldName);
            fieldName = this.fieldSimpleName(fieldName);
            Expression expression = PARSER.parseExpression(fieldParentPath);
            Object object = expression.getValue(target);
            if (Objects.isNull(object)) {
                throw new GracefulResponseException();
            }
            clazz = object.getClass();
        }
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            this.logger.error("\u65e0\u6cd5\u6839\u636e\u5c5e\u6027\u540d\u627e\u5230\u5bf9\u5e94\u7684\u5c5e\u6027,fieldName={}", (Object)fieldName);
            throw new GracefulResponseException("\u83b7\u5f97\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u5c5e\u6027\u5931\u8d25,fieldName={}", fieldName, exception);
        }
        validateStatusCode = field.getAnnotation(ValidationStatusCode.class);
        if (Objects.nonNull(validateStatusCode)) {
            return validateStatusCode;
        }
        validateStatusCode = clazz.getAnnotation(ValidationStatusCode.class);
        if (Objects.nonNull(validateStatusCode)) {
            return validateStatusCode;
        }
        if (target.getClass() != clazz && Objects.nonNull(validateStatusCode = target.getClass().getAnnotation(ValidationStatusCode.class))) {
            return validateStatusCode;
        }
        return null;
    }

    private String fieldSimpleName(String fieldName) {
        int lastIndex = fieldName.lastIndexOf(PACKAGE_SEP);
        return fieldName.substring(lastIndex + 1);
    }

    private String fieldParentPath(String fieldName) {
        int lastIndex = fieldName.lastIndexOf(PACKAGE_SEP);
        return fieldName.substring(0, lastIndex);
    }

    private Method currentControllerMethod() {
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            ServletRequestAttributes sra = (ServletRequestAttributes)requestAttributes;
            HandlerExecutionChain handlerChain = this.requestMappingHandlerMapping.getHandler(sra.getRequest());
            assert (handlerChain != null);
            HandlerMethod handler = (HandlerMethod)handlerChain.getHandler();
            return handler.getMethod();
        }
        catch (Exception e) {
            throw new GracefulResponseException("\u83b7\u53d6\u5f53\u524dController\u65b9\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    private ResponseStatus handleConstraintViolationException(Exception e) {
        ConstraintViolationException exception = (ConstraintViolationException)e;
        Set violationSet = exception.getConstraintViolations();
        String msg = violationSet.stream().map(s -> s.getConstraintDescriptor().getMessageTemplate()).collect(Collectors.joining(";"));
        ValidationStatusCode validationStatusCode = this.findValidationStatusCodeInController();
        if (validationStatusCode != null) {
            String code = validationStatusCode.code();
            return this.responseStatusFactory.newInstance(code, msg);
        }
        String code = this.properties.getDefaultValidateErrorCode();
        if (StringUtils.hasLength((String)code)) {
            return this.responseStatusFactory.newInstance(code, msg);
        }
        code = this.properties.getDefaultErrorCode();
        return this.responseStatusFactory.newInstance(code, msg);
    }

    private ValidationStatusCode findValidationStatusCodeInController() {
        Method method = this.currentControllerMethod();
        ValidationStatusCode validateStatusCode = method.getAnnotation(ValidationStatusCode.class);
        if (validateStatusCode == null) {
            validateStatusCode = method.getDeclaringClass().getAnnotation(ValidationStatusCode.class);
        }
        return validateStatusCode;
    }

    @Override
    public ResponseEntity<Response> process(Response response, Throwable throwable) {
        org.springframework.web.bind.annotation.ResponseStatus httpResponseStatus;
        int httpStatusCodeInt;
        ValidationStatusCode validateStatusCode = (ValidationStatusCode)RequestContextHolder.currentRequestAttributes().getAttribute(VALIDATION_STATUS_CODE, 0);
        HttpStatus httpStatusCode = null;
        if (Objects.nonNull(validateStatusCode) && (httpStatusCodeInt = validateStatusCode.httpStatusCode()) > 0) {
            httpStatusCode = HttpStatus.valueOf((int)httpStatusCodeInt);
        }
        if (Objects.nonNull(httpResponseStatus = (org.springframework.web.bind.annotation.ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(throwable.getClass(), org.springframework.web.bind.annotation.ResponseStatus.class))) {
            httpStatusCode = httpResponseStatus.value();
        }
        if (Objects.isNull(httpStatusCode)) {
            Integer httpStatusCodeInt2 = this.properties.getDefaultHttpStatusCodeOnValidationError();
            if (Objects.isNull(httpStatusCodeInt2)) {
                httpStatusCodeInt2 = this.properties.getDefaultHttpStatusCodeOnError();
            }
            httpStatusCode = HttpStatus.valueOf((int)httpStatusCodeInt2);
        }
        return new ResponseEntity((Object)response, httpStatusCode);
    }
}

