/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse;

import com.feiniaojin.gracefulresponse.GracefulResponseDataException;
import com.feiniaojin.gracefulresponse.GracefulResponseException;
import com.feiniaojin.gracefulresponse.api.AssertFunction;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;

public class GracefulResponse {
    private GracefulResponse() {
        throw new IllegalStateException("Utility class");
    }

    public static void raiseException(String code, String msg) {
        throw new GracefulResponseException(code, msg);
    }

    public static void raiseException(ResponseStatus responseStatus) {
        throw new GracefulResponseException(responseStatus.getCode(), responseStatus.getMsg());
    }

    public static void raiseException(String code, String msg, Throwable throwable) {
        if (throwable instanceof GracefulResponseException) {
            GracefulResponseException gracefulResponseException = (GracefulResponseException)throwable;
            gracefulResponseException.setCode(code);
            gracefulResponseException.setMsg(msg);
            throw gracefulResponseException;
        }
        throw new GracefulResponseException(code, msg, throwable);
    }

    public static void raiseException(ResponseStatus responseStatus, Throwable throwable) {
        if (throwable instanceof GracefulResponseException) {
            GracefulResponseException gracefulResponseException = (GracefulResponseException)throwable;
            gracefulResponseException.setCode(responseStatus.getCode());
            gracefulResponseException.setMsg(responseStatus.getMsg());
            throw gracefulResponseException;
        }
        throw new GracefulResponseException(responseStatus.getCode(), responseStatus.getMsg(), throwable);
    }

    public static void wrapAssert(AssertFunction assertFunction) {
        try {
            assertFunction.doAssert();
        }
        catch (Exception e) {
            throw new GracefulResponseException(e.getMessage(), (Throwable)e);
        }
    }

    public static void wrapAssert(String code, AssertFunction assertFunction) {
        try {
            assertFunction.doAssert();
        }
        catch (Exception e) {
            throw new GracefulResponseException(code, e.getMessage(), e);
        }
    }

    public static void wrapAssert(ResponseStatus responseStatus, AssertFunction assertFunction) {
        try {
            assertFunction.doAssert();
        }
        catch (Exception e) {
            throw new GracefulResponseException(responseStatus, (Throwable)e);
        }
    }

    public static void wrapAssert(String code, Object data, AssertFunction assertFunction) {
        try {
            assertFunction.doAssert();
        }
        catch (Exception e) {
            throw new GracefulResponseDataException(code, e.getMessage(), e, data);
        }
    }
}

