/*
 * Decompiled with CFR 0.152.
 */
package com.felipebz.flr.test.lexer;

import com.felipebz.flr.api.Token;
import com.felipebz.flr.api.TokenType;
import com.felipebz.flr.test.lexer.HasCommentMatcher;
import com.felipebz.flr.test.lexer.HasLastTokenMatcher;
import com.felipebz.flr.test.lexer.HasTokenMatcher;
import com.felipebz.flr.test.lexer.HasTokenTypeMatcher;
import com.felipebz.flr.test.lexer.HasTokenValueMatcher;
import com.felipebz.flr.test.lexer.HasTokensMatcher;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J$\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J$\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\f\u001a\u00020\bH\u0007J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\f\u001a\u00020\bH\u0007J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J-\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0014\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/felipebz/flr/test/lexer/LexerMatchers;", "", "()V", "hasComment", "Lorg/hamcrest/Matcher;", "", "Lcom/felipebz/flr/api/Token;", "commentValue", "", "commentLine", "", "hasLastToken", "tokenValue", "tokenType", "Lcom/felipebz/flr/api/TokenType;", "hasOriginalComment", "hasOriginalToken", "hasToken", "hasTokens", "tokenValues", "", "([Ljava/lang/String;)Lorg/hamcrest/Matcher;", "flr-testing-harness"})
public final class LexerMatchers {
    @NotNull
    public static final LexerMatchers INSTANCE = new LexerMatchers();

    private LexerMatchers() {
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasToken(@NotNull String tokenValue, @NotNull TokenType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenValue, (String)"tokenValue");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return (Matcher)new HasTokenMatcher(tokenValue, tokenType);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasToken(@NotNull String tokenValue) {
        Intrinsics.checkNotNullParameter((Object)tokenValue, (String)"tokenValue");
        return (Matcher)new HasTokenValueMatcher(tokenValue, false, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasOriginalToken(@NotNull String tokenValue) {
        Intrinsics.checkNotNullParameter((Object)tokenValue, (String)"tokenValue");
        return (Matcher)new HasTokenValueMatcher(tokenValue, true);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasToken(@NotNull TokenType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return (Matcher)new HasTokenTypeMatcher(tokenType);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasTokens(String ... tokenValues) {
        Intrinsics.checkNotNullParameter((Object)tokenValues, (String)"tokenValues");
        return (Matcher)new HasTokensMatcher(Arrays.copyOf(tokenValues, tokenValues.length));
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasLastToken(@NotNull String tokenValue, @NotNull TokenType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenValue, (String)"tokenValue");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return (Matcher)new HasLastTokenMatcher(tokenValue, tokenType);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasComment(@NotNull String commentValue) {
        Intrinsics.checkNotNullParameter((Object)commentValue, (String)"commentValue");
        return (Matcher)new HasCommentMatcher(commentValue);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasComment(@NotNull String commentValue, int commentLine) {
        Intrinsics.checkNotNullParameter((Object)commentValue, (String)"commentValue");
        return (Matcher)new HasCommentMatcher(commentValue, commentLine, false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasOriginalComment(@NotNull String commentValue) {
        Intrinsics.checkNotNullParameter((Object)commentValue, (String)"commentValue");
        return (Matcher)new HasCommentMatcher(commentValue, true);
    }

    @JvmStatic
    @NotNull
    public static final Matcher<List<Token>> hasOriginalComment(@NotNull String commentValue, int commentLine) {
        Intrinsics.checkNotNullParameter((Object)commentValue, (String)"commentValue");
        return (Matcher)new HasCommentMatcher(commentValue, commentLine, true);
    }
}

