/*
 * Decompiled with CFR 0.152.
 */
package com.felipebz.flr.test.lexer;

import com.felipebz.flr.api.GenericTokenType;
import com.felipebz.flr.api.Token;
import com.felipebz.flr.api.TokenType;
import com.felipebz.flr.channel.CodeReader;
import com.felipebz.flr.test.lexer.MockHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/felipebz/flr/test/lexer/TokenUtils;", "", "()V", "lex", "", "Lcom/felipebz/flr/api/Token;", "sourceCode", "", "merge", "tokens", "removeLastTokenIfEof", "flr-testing-harness"})
public final class TokenUtils {
    @NotNull
    public static final TokenUtils INSTANCE = new TokenUtils();

    private TokenUtils() {
    }

    @NotNull
    public final String merge(@NotNull List<Token> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        List<Token> tokens2 = tokens;
        tokens2 = this.removeLastTokenIfEof(tokens2);
        StringBuilder result = new StringBuilder();
        int n = tokens2.size();
        for (int i = 0; i < n; ++i) {
            Token token = tokens2.get(i);
            result.append(token.getValue());
            if (i >= tokens2.size() - 1) continue;
            result.append(" ");
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final List<Token> removeLastTokenIfEof(List<Token> tokens) {
        Token lastToken;
        if (!((Collection)tokens).isEmpty() && Intrinsics.areEqual((Object)"EOF", (Object)(lastToken = tokens.get(tokens.size() - 1)).getValue())) {
            return tokens.subList(0, tokens.size() - 1);
        }
        return tokens;
    }

    @NotNull
    public final List<Token> lex(@NotNull String sourceCode) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        List tokens = new ArrayList();
        CodeReader reader = new CodeReader(sourceCode);
        Matcher matcher = Pattern.compile("[a-zA-Z_0-9\\+\\-\\*/]+").matcher("");
        while (reader.peek() != -1) {
            Token token;
            StringBuilder nextStringToken = new StringBuilder();
            Token token2 = null;
            int linePosition = reader.getLinePosition();
            int columnPosition = reader.getColumnPosition();
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher");
            if (reader.popTo(matcher, (Appendable)nextStringToken) != -1) {
                if (Intrinsics.areEqual((Object)"EOF", (Object)nextStringToken.toString())) {
                    TokenType tokenType = (TokenType)GenericTokenType.EOF;
                    String string = nextStringToken.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextStringToken.toString()");
                    token = MockHelper.mockTokenBuilder(tokenType, string).setLine(linePosition).setColumn(columnPosition).build();
                } else {
                    TokenType tokenType = (TokenType)GenericTokenType.IDENTIFIER;
                    String string = nextStringToken.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextStringToken.toString()");
                    token = MockHelper.mockTokenBuilder(tokenType, string).setLine(linePosition).setColumn(columnPosition).build();
                }
            } else {
                if (Character.isWhitespace(reader.peek())) {
                    reader.pop();
                    continue;
                }
                token = MockHelper.mockTokenBuilder((TokenType)GenericTokenType.IDENTIFIER, String.valueOf((char)reader.pop())).setLine(linePosition).setColumn(columnPosition).build();
            }
            token2 = token;
            tokens.add(token2);
        }
        return tokens;
    }
}

