/*
 * Decompiled with CFR 0.152.
 */
package com.felipebz.flr.test.minic;

import com.felipebz.flr.api.AstNode;
import com.felipebz.flr.api.Grammar;
import com.felipebz.flr.impl.Parser;
import com.felipebz.flr.test.minic.MiniCGrammar;
import com.felipebz.flr.test.minic.MiniCLexer;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/felipebz/flr/test/minic/MiniCParser;", "", "()V", "P", "Lcom/felipebz/flr/impl/Parser;", "Lcom/felipebz/flr/api/Grammar;", "create", "parseFile", "Lcom/felipebz/flr/api/AstNode;", "filePath", "", "parseString", "source", "flr-testing-harness"})
public final class MiniCParser {
    @NotNull
    public static final MiniCParser INSTANCE = new MiniCParser();
    @NotNull
    private static final Parser<Grammar> P = INSTANCE.create();

    private MiniCParser() {
    }

    @NotNull
    public final Parser<Grammar> create() {
        return Parser.Companion.builder(MiniCGrammar.Companion.create()).withLexer(MiniCLexer.INSTANCE.create()).build();
    }

    @NotNull
    public final AstNode parseFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(MiniCParser.class.getResource(filePath).getPath());
        if (!file.exists()) {
            throw new AssertionError((Object)("The file \"" + filePath + "\" does not exist."));
        }
        return P.parse(file);
    }

    @NotNull
    public final AstNode parseString(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return P.parse(source);
    }
}

