/*
 * Decompiled with CFR 0.152.
 */
package com.felipebz.flr.tests;

import com.felipebz.flr.api.GenericTokenType;
import com.felipebz.flr.api.RecognitionException;
import com.felipebz.flr.api.Rule;
import com.felipebz.flr.api.TokenType;
import com.felipebz.flr.grammar.GrammarRuleKey;
import com.felipebz.flr.grammar.LexerfulGrammarBuilder;
import com.felipebz.flr.impl.Parser;
import com.felipebz.flr.impl.matcher.RuleDefinition;
import com.felipebz.flr.internal.vm.EndOfInputExpression;
import com.felipebz.flr.internal.vm.FirstOfExpression;
import com.felipebz.flr.internal.vm.ParsingExpression;
import com.felipebz.flr.internal.vm.lexerful.TokenTypeExpression;
import com.felipebz.flr.tests.Assertions;
import com.felipebz.flr.tests.ParsingResultComparisonFailure;
import com.felipebz.flr.tests.RuleAssert;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.fest.assertions.GenericAssert;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lcom/felipebz/flr/tests/ParserAssert;", "Lorg/fest/assertions/GenericAssert;", "Lcom/felipebz/flr/impl/Parser;", "actual", "(Lcom/felipebz/flr/impl/Parser;)V", "createParserWithEofMatcher", "getRuleName", "", "hasRootRule", "", "matches", "input", "notMatches", "flr-testing-harness"})
public final class ParserAssert
extends GenericAssert<ParserAssert, Parser<?>> {
    public ParserAssert(@NotNull Parser<?> actual) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        super(ParserAssert.class, actual);
    }

    private final Parser<?> createParserWithEofMatcher() {
        RuleDefinition rule = ((Parser)this.actual).getRootRule();
        LexerfulGrammarBuilder builder = LexerfulGrammarBuilder.Companion.create();
        RuleAssert.WithEndOfInput withEndOfInputKey = new RuleAssert.WithEndOfInput(rule.getRuleKey());
        Object[] objectArray = new Object[1];
        ParsingExpression[] parsingExpressionArray = new ParsingExpression[]{(ParsingExpression)EndOfInputExpression.INSTANCE, (ParsingExpression)new TokenTypeExpression((TokenType)GenericTokenType.EOF)};
        objectArray[0] = new FirstOfExpression(parsingExpressionArray);
        builder.rule((GrammarRuleKey)withEndOfInputKey).is((Object)rule, objectArray);
        builder.setRootRule((GrammarRuleKey)withEndOfInputKey);
        Object object = this.actual;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actual");
        Parser parser = Parser.Companion.builder((Parser)object).build();
        parser.setRootRule(builder.build().getRootRule());
        return parser;
    }

    @NotNull
    public final ParserAssert matches(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.isNotNull();
        this.hasRootRule();
        Parser<?> parser = this.createParserWithEofMatcher();
        String expected = StringsKt.trimIndent((String)("\n             Rule '" + this.getRuleName() + "' should match:\n             " + input + "\n             "));
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            String actual = e.getMessage();
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    @NotNull
    public final ParserAssert notMatches(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.isNotNull();
        this.hasRootRule();
        Parser<?> parser = this.createParserWithEofMatcher();
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            return this;
        }
        throw new AssertionError((Object)StringsKt.trimIndent((String)("\n    Rule '" + this.getRuleName() + "' should not match:\n    " + input + "\n    ")));
    }

    private final void hasRootRule() {
        ((RuleAssert)((Object)Assertions.INSTANCE.assertThat((Rule)((Parser)this.actual).getRootRule()).overridingErrorMessage("Root rule of the parser should not be null"))).isNotNull();
    }

    private final String getRuleName() {
        return ((Parser)this.actual).getRootRule().getName();
    }
}

