/*
 * Decompiled with CFR 0.152.
 */
package com.felipebz.flr.tests;

import com.felipebz.flr.api.Rule;
import com.felipebz.flr.grammar.GrammarRuleBuilder;
import com.felipebz.flr.grammar.GrammarRuleKey;
import com.felipebz.flr.grammar.LexerlessGrammarBuilder;
import com.felipebz.flr.internal.grammar.MutableParsingRule;
import com.felipebz.flr.internal.vm.EndOfInputExpression;
import com.felipebz.flr.parser.ParseErrorFormatter;
import com.felipebz.flr.parser.ParseRunner;
import com.felipebz.flr.parser.ParsingResult;
import com.felipebz.flr.tests.ParsingResultComparisonFailure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.fest.assertions.GenericAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lcom/felipebz/flr/tests/RuleAssert;", "Lorg/fest/assertions/GenericAssert;", "Lcom/felipebz/flr/api/Rule;", "actual", "(Lcom/felipebz/flr/api/Rule;)V", "createParseRunnerWithEofMatcher", "Lcom/felipebz/flr/parser/ParseRunner;", "createParseRunnerWithoutEofMatcher", "getRuleName", "", "matches", "input", "matchesPrefix", "prefixToBeMatched", "remainingInput", "notMatches", "WithEndOfInput", "flr-testing-harness"})
public final class RuleAssert
extends GenericAssert<RuleAssert, Rule> {
    public RuleAssert(@Nullable Rule actual) {
        super(RuleAssert.class, (Object)actual);
    }

    private final ParseRunner createParseRunnerWithEofMatcher() {
        this.isNotNull();
        Object object = this.actual;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.felipebz.flr.internal.grammar.MutableParsingRule");
        MutableParsingRule rule = (MutableParsingRule)object;
        LexerlessGrammarBuilder builder = LexerlessGrammarBuilder.Companion.create();
        WithEndOfInput withEndOfInputKey = new WithEndOfInput(rule.getRuleKey());
        GrammarRuleBuilder grammarRuleBuilder = builder.rule((GrammarRuleKey)withEndOfInputKey);
        Object object2 = this.actual;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"actual");
        Object[] objectArray = new Object[]{EndOfInputExpression.INSTANCE};
        grammarRuleBuilder.is(object2, objectArray);
        builder.setRootRule((GrammarRuleKey)withEndOfInputKey);
        return new ParseRunner(builder.build().getRootRule());
    }

    @NotNull
    public final RuleAssert matches(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseRunner parseRunner = this.createParseRunnerWithEofMatcher();
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        ParsingResult parsingResult = parseRunner.parse(cArray);
        if (!parsingResult.isMatched()) {
            String expected = StringsKt.trimIndent((String)("\n                Rule '" + this.getRuleName() + "' should match:\n                " + input + "\n                "));
            String actual = new ParseErrorFormatter().format(parsingResult.getParseError());
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    @NotNull
    public final RuleAssert notMatches(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseRunner parseRunner = this.createParseRunnerWithEofMatcher();
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        ParsingResult parsingResult = parseRunner.parse(cArray);
        if (parsingResult.isMatched()) {
            throw new AssertionError((Object)StringsKt.trimIndent((String)("\n    Rule '" + this.getRuleName() + "' should not match:\n    " + input + "\n    ")));
        }
        return this;
    }

    private final ParseRunner createParseRunnerWithoutEofMatcher() {
        this.isNotNull();
        Object object = this.actual;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actual");
        return new ParseRunner((Rule)object);
    }

    @NotNull
    public final RuleAssert matchesPrefix(@NotNull String prefixToBeMatched, @NotNull String remainingInput) {
        Intrinsics.checkNotNullParameter((Object)prefixToBeMatched, (String)"prefixToBeMatched");
        Intrinsics.checkNotNullParameter((Object)remainingInput, (String)"remainingInput");
        ParseRunner parseRunner = this.createParseRunnerWithoutEofMatcher();
        String input = prefixToBeMatched + remainingInput;
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        ParsingResult parsingResult = parseRunner.parse(cArray);
        if (!parsingResult.isMatched()) {
            String expected = StringsKt.trimIndent((String)("\n                Rule '" + this.getRuleName() + "' should match:\n                " + prefixToBeMatched + "\n                when followed by:\n                " + remainingInput + "\n                "));
            String actual = new ParseErrorFormatter().format(parsingResult.getParseError());
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        if (prefixToBeMatched.length() != parsingResult.getParseTreeRoot().getEndIndex()) {
            String string = input.substring(0, parsingResult.getParseTreeRoot().getEndIndex());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String actualMatchedPrefix = string;
            String message = StringsKt.trimIndent((String)("\n                Rule '" + this.getRuleName() + "' should match:\n                " + prefixToBeMatched + "\n                when followed by:\n                " + remainingInput + "\n                but matched:\n                " + actualMatchedPrefix + "\n                "));
            throw new ParsingResultComparisonFailure(message, prefixToBeMatched, actualMatchedPrefix);
        }
        return this;
    }

    private final String getRuleName() {
        Object object = this.actual;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.felipebz.flr.internal.grammar.MutableParsingRule");
        return ((MutableParsingRule)object).getName();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/felipebz/flr/tests/RuleAssert$WithEndOfInput;", "Lcom/felipebz/flr/grammar/GrammarRuleKey;", "ruleKey", "(Lcom/felipebz/flr/grammar/GrammarRuleKey;)V", "toString", "", "flr-testing-harness"})
    public static final class WithEndOfInput
    implements GrammarRuleKey {
        @Nullable
        private final GrammarRuleKey ruleKey;

        public WithEndOfInput(@Nullable GrammarRuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        @NotNull
        public String toString() {
            return this.ruleKey + " with end of input";
        }
    }
}

