/*
 * Decompiled with CFR 0.152.
 */
package org.js.cycle.android;

import java.util.HashMap;
import java.util.Map;
import org.js.cycle.android.Sink;
import org.js.cycle.android.Sinks;
import org.js.cycle.android.Source;
import org.js.cycle.android.Sources;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;

public final class Cycle {
    public static void run(Func1<Sources, Sinks> main, Source ... sourceList) {
        Sources sources = Sources.create(sourceList);
        Map<String, ReplaySubject<?>> sinkProxies = Cycle.createAndApplySinkProxies(sources);
        Sinks sinks = (Sinks)main.call((Object)sources);
        Cycle.subscribeProxies(sinkProxies, sinks);
    }

    private static void subscribeProxies(Map<String, ReplaySubject<?>> sinkProxies, Sinks sinks) {
        for (Sink sink : sinks) {
            Observer proxy = (Observer)sinkProxies.get(sink.name());
            if (proxy == null) continue;
            sink.stream().subscribe(proxy);
        }
    }

    private static Map<String, ReplaySubject<?>> createAndApplySinkProxies(Sources sources) {
        HashMap sinkProxies = new HashMap();
        for (Source source : sources.list()) {
            ReplaySubject sinkProxy = ReplaySubject.create((int)1);
            sinkProxies.put(source.name(), sinkProxy);
            source.apply((Observable<?>)sinkProxy);
        }
        return sinkProxies;
    }
}

