/*
 * Decompiled with CFR 0.152.
 */
package org.js.cycle.android;

import android.support.annotation.Nullable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.NumberPicker;
import org.js.cycle.android.ClickEventInterceptingLayout;
import org.js.cycle.android.DomDriver$$Lambda$1;
import org.js.cycle.android.DomDriver$$Lambda$2;
import org.js.cycle.android.Driver;
import org.js.cycle.android.Event;
import org.js.cycle.android.ObservableOnValueChangeListener;
import org.js.cycle.android.ObservableTextWatcher;
import org.js.cycle.android.Util;
import rx.Observable;
import rx.Observer;
import rx.subjects.PublishSubject;
import trikita.anvil.Anvil;

public final class DomDriver
implements Driver {
    private final ViewGroup root;
    private final PublishSubject<Event> domEvents = PublishSubject.create();
    private ClickEventInterceptingLayout touchInterceptor;

    private DomDriver(ViewGroup root) {
        this.root = root;
    }

    public static DomDriver makeDomDriver(ViewGroup target) {
        return new DomDriver(target);
    }

    @Override
    public void apply(Observable<?> stream) {
        stream.subscribe((Observer)new Observer<Anvil.Renderable>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                throw new RuntimeException(e);
            }

            public void onNext(Anvil.Renderable renderable) {
                Anvil.mount((View)DomDriver.this.root, (Anvil.Renderable)renderable);
                DomDriver.this.maybeInjectClickInterceptingLayout();
                DomDriver.this.recursivelySetListeners((ViewGroup)DomDriver.this.touchInterceptor);
            }
        });
    }

    private void maybeInjectClickInterceptingLayout() {
        if (this.touchInterceptor == null) {
            if (this.root.getParent() == null || !(this.root.getParent() instanceof ViewGroup)) {
                throw new IllegalStateException("The root View must have a parent ViewGroup.");
            }
            if (this.root.getParent() instanceof ClickEventInterceptingLayout) {
                this.touchInterceptor = (ClickEventInterceptingLayout)this.root.getParent();
            } else {
                this.touchInterceptor = new ClickEventInterceptingLayout(this.root.getContext());
                Observable<Event> observable = this.touchInterceptor.clickEventsObservable();
                PublishSubject<Event> publishSubject = this.domEvents;
                publishSubject.getClass();
                observable.subscribe(DomDriver$$Lambda$1.lambdaFactory$(publishSubject));
                Util.wrapViewWith((View)this.root, (ViewGroup)this.touchInterceptor);
            }
        }
    }

    private void recursivelySetListeners(ViewGroup viewGroup) {
        int count = viewGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof NumberPicker) {
                this.subscribe(this.maybeSetValueChangedListener((NumberPicker)view));
                continue;
            }
            if (view instanceof EditText) {
                this.subscribe(this.maybeSetTextChangedListener((EditText)view));
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.recursivelySetListeners((ViewGroup)view);
        }
    }

    private void subscribe(@Nullable Observable<Event> observable) {
        if (observable != null) {
            PublishSubject<Event> publishSubject = this.domEvents;
            publishSubject.getClass();
            observable.subscribe(DomDriver$$Lambda$2.lambdaFactory$(publishSubject));
        }
    }

    @Nullable
    private Observable<Event> maybeSetValueChangedListener(NumberPicker view) {
        if (view.getTag() == null || !(view.getTag() instanceof NumberPicker.OnValueChangeListener)) {
            ObservableOnValueChangeListener listener = new ObservableOnValueChangeListener();
            view.setOnValueChangedListener((NumberPicker.OnValueChangeListener)listener);
            view.setTag((Object)listener);
            return listener.observable();
        }
        return null;
    }

    @Nullable
    private Observable<Event> maybeSetTextChangedListener(EditText editText) {
        if (editText.getTag() == null || !(editText.getTag() instanceof ObservableTextWatcher)) {
            ObservableTextWatcher watcher = ObservableTextWatcher.create(editText);
            editText.addTextChangedListener((TextWatcher)watcher);
            editText.setTag((Object)watcher);
            return watcher.observable();
        }
        return null;
    }

    Observable<Event> events() {
        return this.domEvents;
    }
}

