/*
 * Decompiled with CFR 0.152.
 */
package org.js.cycle.android;

import java.util.Arrays;
import java.util.List;
import org.js.cycle.android.DomSource;
import org.js.cycle.android.HttpSource;
import org.js.cycle.android.PropsSource;
import org.js.cycle.android.Source;

public class Sources {
    private final List<Source> sources;

    private Sources(Source ... sources) {
        this.sources = Arrays.asList(sources);
    }

    public static Sources create(Source ... sources) {
        return new Sources(sources);
    }

    public DomSource dom() {
        return (DomSource)this.findSourceByName("DOM");
    }

    public HttpSource http() {
        return (HttpSource)this.findSourceByName("HTTP");
    }

    public List<Source> list() {
        return this.sources;
    }

    private Source findSourceByName(String name) {
        for (Source source : this.sources) {
            if (!source.name().equals(name)) continue;
            return source;
        }
        throw new IllegalArgumentException("Source not found with name=" + name);
    }

    public PropsSource props() {
        return (PropsSource)this.findSourceByName("PROPS");
    }
}

