/*
 * Decompiled with CFR 0.152.
 */
package org.js.cycle.android;

import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

final class Util {
    private Util() {
    }

    static boolean viewMatchesSelector(View view, List<Integer> filteringScope) {
        if (filteringScope.isEmpty()) {
            return true;
        }
        if (filteringScope.size() == 1) {
            return view.getId() == filteringScope.get(0).intValue();
        }
        ArrayList<Integer> newScope = new ArrayList<Integer>(filteringScope);
        newScope.remove(newScope.get(newScope.size() - 1));
        return view.getParent() != null && Util.viewMatchesSelector((View)view.getParent(), newScope);
    }

    static void wrapViewWith(View view, ViewGroup wrapper) {
        ViewGroup parent = (ViewGroup)view.getParent();
        int rootIndex = parent.indexOfChild(view);
        parent.removeView(view);
        parent.addView((View)wrapper, rootIndex);
        wrapper.addView(view);
    }

    @Nullable
    static View getClickTarget(View view, MotionEvent e) {
        boolean isHit = Util.hitTest(e.getRawX(), e.getRawY(), view);
        if (isHit && !(view instanceof ViewGroup)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                View clickTarget = Util.getClickTarget(child, e);
                if (clickTarget == null) continue;
                return clickTarget;
            }
        }
        return isHit ? view : null;
    }

    private static boolean hitTest(float x, float y, View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int viewX = location[0];
        int viewY = location[1];
        return x > (float)viewX && x < (float)(viewX + view.getWidth()) && y > (float)viewY && y < (float)(viewY + view.getHeight());
    }

    static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }
}

