/*
 * Decompiled with CFR 0.152.
 */
package com.felipecsl.gifimageview.library;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.felipecsl.gifimageview.library.GifDecoder;

public class GifImageView
extends ImageView
implements Runnable {
    private static final String TAG = "GifDecoderView";
    private GifDecoder gifDecoder;
    private Bitmap tmpBitmap;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private boolean animating;
    private boolean shouldClear;
    private Thread animationThread;
    private OnFrameAvailable frameCallback = null;
    private long framesDisplayDuration = -1L;
    private final Runnable updateResults = new Runnable(){

        @Override
        public void run() {
            if (GifImageView.this.tmpBitmap != null && !GifImageView.this.tmpBitmap.isRecycled()) {
                GifImageView.this.setImageBitmap(GifImageView.this.tmpBitmap);
            }
        }
    };
    private final Runnable cleanupRunnable = new Runnable(){

        @Override
        public void run() {
            if (GifImageView.this.tmpBitmap != null && !GifImageView.this.tmpBitmap.isRecycled()) {
                GifImageView.this.tmpBitmap.recycle();
            }
            GifImageView.this.tmpBitmap = null;
            GifImageView.this.gifDecoder = null;
            GifImageView.this.animationThread = null;
            GifImageView.this.shouldClear = false;
        }
    };

    public GifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GifImageView(Context context) {
        super(context);
    }

    public void setBytes(byte[] bytes) {
        this.gifDecoder = new GifDecoder();
        try {
            this.gifDecoder.read(bytes);
            this.gifDecoder.advance();
        }
        catch (OutOfMemoryError e) {
            this.gifDecoder = null;
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return;
        }
        if (this.canStart()) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public long getFramesDisplayDuration() {
        return this.framesDisplayDuration;
    }

    public void setFramesDisplayDuration(long framesDisplayDuration) {
        this.framesDisplayDuration = framesDisplayDuration;
    }

    public void startAnimation() {
        this.animating = true;
        if (this.canStart()) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void stopAnimation() {
        this.animating = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
    }

    public void clear() {
        this.animating = false;
        this.shouldClear = true;
        this.stopAnimation();
    }

    private boolean canStart() {
        return this.animating && this.gifDecoder != null && this.animationThread == null;
    }

    public int getGifWidth() {
        return this.gifDecoder.getWidth();
    }

    public int getGifHeight() {
        return this.gifDecoder.getHeight();
    }

    @Override
    public void run() {
        if (this.shouldClear) {
            this.handler.post(this.cleanupRunnable);
            return;
        }
        int n = this.gifDecoder.getFrameCount();
        block4: do {
            for (int i = 0; i < n && this.animating; ++i) {
                long frameDecodeTime = 0L;
                try {
                    long before = System.nanoTime();
                    this.tmpBitmap = this.gifDecoder.getNextFrame();
                    frameDecodeTime = (System.nanoTime() - before) / 1000000L;
                    if (this.frameCallback != null) {
                        this.tmpBitmap = this.frameCallback.onFrameAvailable(this.tmpBitmap);
                    }
                    if (!this.animating) continue block4;
                    this.handler.post(this.updateResults);
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                if (!this.animating) continue block4;
                this.gifDecoder.advance();
                try {
                    int delay = this.gifDecoder.getNextDelay();
                    delay = (int)((long)delay - frameDecodeTime);
                    if (delay <= 0) continue;
                    Thread.sleep(this.framesDisplayDuration > 0L ? this.framesDisplayDuration : (long)delay);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (this.animating);
    }

    public OnFrameAvailable getOnFrameAvailable() {
        return this.frameCallback;
    }

    public void setOnFrameAvailable(OnFrameAvailable frameProcessor) {
        this.frameCallback = frameProcessor;
    }

    public static interface OnFrameAvailable {
        public Bitmap onFrameAvailable(Bitmap var1);
    }
}

