/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.quartz;

import com.fengwenyi.javalib.quartz.ScheduleBean;
import com.fengwenyi.javalib.quartz.TimeTypeEnum;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzTask {
    private static Scheduler scheduler;

    public boolean start(ScheduleBean scheduleBean) throws SchedulerException {
        if (!this.status()) {
            if (scheduleBean == null) {
                return false;
            }
            JobDetail jobDetail = this.getJobDetail(scheduleBean);
            TimeTypeEnum timeTypeEnum = scheduleBean.getTimeType();
            Trigger trigger = null;
            if (timeTypeEnum == null) {
                switch (timeTypeEnum.getCode()) {
                    case 1: {
                        trigger = this.getTriggerBySimple(scheduleBean);
                        break;
                    }
                    case 2: {
                        trigger = this.getTriggerByAtTime(scheduleBean);
                        break;
                    }
                    case 3: {
                        trigger = this.getTriggerByCron(scheduleBean);
                        break;
                    }
                    default: {
                        trigger = this.getTrigger(scheduleBean);
                        break;
                    }
                }
            } else {
                trigger = this.getTrigger(scheduleBean);
            }
            if (scheduler == null) {
                scheduler = scheduleBean.getScheduler();
            }
            if (jobDetail != null && trigger != null) {
                this.paramJob(jobDetail, scheduleBean.getParamJobMap());
                this.paramTrigger(trigger, scheduleBean.getParamTriggerMap());
                scheduler.scheduleJob(jobDetail, trigger);
            }
            scheduler.start();
            return true;
        }
        return false;
    }

    public boolean status() throws SchedulerException {
        if (scheduler != null) {
            return scheduler.isStarted();
        }
        return false;
    }

    public boolean stop() throws SchedulerException {
        if (scheduler != null) {
            scheduler.shutdown();
            return true;
        }
        return false;
    }

    public boolean pauseAll() throws SchedulerException {
        if (scheduler != null) {
            scheduler.pauseAll();
            return true;
        }
        return false;
    }

    public boolean pauseByJobKey(JobKey jobKey) throws SchedulerException {
        if (scheduler != null) {
            scheduler.pauseJob(jobKey);
            return true;
        }
        return false;
    }

    public boolean pauseByJobKeys(GroupMatcher<JobKey> jobKeys) throws SchedulerException {
        if (scheduler != null) {
            scheduler.pauseJobs(jobKeys);
            return true;
        }
        return false;
    }

    public boolean pauseByTriggerKey(TriggerKey triggerKey) throws SchedulerException {
        if (scheduler != null) {
            scheduler.pauseTrigger(triggerKey);
            return true;
        }
        return false;
    }

    public boolean pauseByTriggerKeys(GroupMatcher<TriggerKey> triggerKeys) throws SchedulerException {
        if (scheduler != null) {
            scheduler.pauseTriggers(triggerKeys);
            return true;
        }
        return false;
    }

    private JobDetail getJobDetail(ScheduleBean scheduleBean) {
        return JobBuilder.newJob(scheduleBean.getClazz()).withIdentity(scheduleBean.getJobName(), scheduleBean.getJobGroup()).build();
    }

    private void paramJob(JobDetail obj, Map<String, Object> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            Set<String> keys = paramMap.keySet();
            for (String key : keys) {
                obj.getJobDataMap().put(key, paramMap.get(key));
            }
        }
    }

    private void paramTrigger(Trigger obj, Map<String, Object> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            Set<String> keys = paramMap.keySet();
            for (String key : keys) {
                obj.getJobDataMap().put(key, paramMap.get(key));
            }
        }
    }

    private Trigger getTriggerSimple(ScheduleBean scheduleBean) {
        return TriggerBuilder.newTrigger().withIdentity(scheduleBean.getTriggerName(), scheduleBean.getTriggerGroup()).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(scheduleBean.getTime().intValue()).repeatForever()).build();
    }

    private Trigger getTriggerAtTime(ScheduleBean scheduleBean) {
        return TriggerBuilder.newTrigger().withIdentity(scheduleBean.getTriggerName(), scheduleBean.getTriggerGroup()).startAt(new Date(scheduleBean.getAtTime())).build();
    }

    private Trigger getTriggerCron(ScheduleBean scheduleBean) {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleBean.getCron());
        return TriggerBuilder.newTrigger().withIdentity(scheduleBean.getTriggerName(), scheduleBean.getTriggerGroup()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }

    private Trigger getTrigger(ScheduleBean scheduleBean) {
        Integer time;
        Long atTime;
        Trigger trigger = null;
        String cron = scheduleBean.getCron();
        if (null != cron && !"".equals(cron.trim()) && cron.length() > 0) {
            trigger = this.getTriggerCron(scheduleBean);
        }
        if (null != (atTime = scheduleBean.getAtTime()) && atTime > 0L) {
            trigger = this.getTriggerAtTime(scheduleBean);
        }
        if (null != (time = scheduleBean.getTime()) && time > 0) {
            trigger = this.getTriggerSimple(scheduleBean);
        }
        return trigger;
    }

    private Trigger getTriggerBySimple(ScheduleBean scheduleBean) {
        return this.getTrigger(scheduleBean);
    }

    private Trigger getTriggerByAtTime(ScheduleBean scheduleBean) {
        Long atTime;
        Integer time;
        Trigger trigger = null;
        String cron = scheduleBean.getCron();
        if (null != cron && !"".equals(cron.trim()) && cron.length() > 0) {
            trigger = this.getTriggerCron(scheduleBean);
        }
        if (null != (time = scheduleBean.getTime()) && time > 0) {
            trigger = this.getTriggerSimple(scheduleBean);
        }
        if (null != (atTime = scheduleBean.getAtTime()) && atTime > 0L) {
            trigger = this.getTriggerAtTime(scheduleBean);
        }
        return trigger;
    }

    private Trigger getTriggerByCron(ScheduleBean scheduleBean) {
        String cron;
        Integer time;
        Trigger trigger = null;
        Long atTime = scheduleBean.getAtTime();
        if (null != atTime && atTime > 0L) {
            trigger = this.getTriggerAtTime(scheduleBean);
        }
        if (null != (time = scheduleBean.getTime()) && time > 0) {
            trigger = this.getTriggerSimple(scheduleBean);
        }
        if (null != (cron = scheduleBean.getCron()) && !"".equals(cron.trim()) && cron.length() > 0) {
            trigger = this.getTriggerCron(scheduleBean);
        }
        return trigger;
    }
}

