/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.convert;

import com.fengwenyi.javalib.util.StrUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Objects;

public class DateTimeUtils {
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";

    public static String format(LocalDateTime dateTime, String pattern) {
        if (Objects.isNull(dateTime) || StrUtils.isBlank(pattern)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return dateTime.format(formatter);
    }

    public static String format(LocalDate date, String pattern) {
        if (Objects.isNull(date) || StrUtils.isBlank(pattern)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return date.format(formatter);
    }

    public static String format(Date date, String pattern) {
        if (Objects.isNull(date) || StrUtils.isBlank(pattern)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static String format(Long timestamp, String pattern) {
        if (Objects.isNull(timestamp) || StrUtils.isBlank(pattern)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(timestamp);
    }

    public static String format(Instant instant, String pattern) {
        if (Objects.isNull(instant) || StrUtils.isBlank(pattern)) {
            return "";
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(OffsetDateTime offsetDateTime, String pattern) {
        if (Objects.isNull(offsetDateTime) || StrUtils.isBlank(pattern)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return offsetDateTime.format(formatter);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr, String pattern) {
        if (StrUtils.isBlank(dateTimeStr) || StrUtils.isBlank(pattern)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(dateTimeStr, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr, String pattern, String zoneId) {
        if (StrUtils.isBlank(dateTimeStr) || StrUtils.isBlank(pattern) || StrUtils.isBlank(zoneId)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of(zoneId));
        OffsetDateTime odt = OffsetDateTime.parse(dateTimeStr, formatter);
        return odt.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate parseLocalDate(String date) {
        if (StrUtils.isBlank(date)) {
            return null;
        }
        return LocalDate.parse(date);
    }

    public static LocalDate parseLocalDate(String dateStr, String pattern) {
        if (StrUtils.isBlank(dateStr) || StrUtils.isBlank(pattern)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.parse(dateStr, formatter);
    }

    public static Instant parseInstant(String source) {
        if (StrUtils.isBlank(source)) {
            return null;
        }
        LocalDate date = LocalDate.parse(source);
        return date.atStartOfDay(ZoneId.systemDefault()).toInstant();
    }

    public static Instant parseInstant(String source, String pattern) {
        if (StrUtils.isBlank(source) || StrUtils.isBlank(pattern)) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime dateTime = LocalDateTime.parse(source, dateTimeFormatter);
        return dateTime.atZone(ZoneOffset.systemDefault()).toInstant();
    }

    public static Date parseDate(String source, String pattern) {
        if (StrUtils.isBlank(source) || StrUtils.isBlank(pattern)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        try {
            return simpleDateFormat.parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Long toMillisecond(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long toMillisecond(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Long toMillisecond(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        return localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Long toSecond(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        if (Objects.isNull(instant)) {
            return null;
        }
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Instant toInstant(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return DateTimeUtils.toLocalDateTime(DateTimeUtils.toInstant(date));
    }

    public static Boolean isBefore(LocalDateTime before, LocalDateTime after) {
        if (Objects.isNull(before) || Objects.isNull(after)) {
            return null;
        }
        return before.isBefore(after);
    }

    public static LocalDateTime toLocalDateTime(Long timestamp) {
        if (Objects.isNull(timestamp)) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return OffsetDateTime.of(localDateTime, ZoneId.systemDefault().getRules().getOffset(localDateTime));
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (Objects.isNull(localDateTime) || Objects.isNull(zoneOffset)) {
            return null;
        }
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime, String offsetId) {
        if (Objects.isNull(localDateTime) || StrUtils.isBlank(offsetId)) {
            return null;
        }
        return OffsetDateTime.of(localDateTime, ZoneOffset.of(offsetId));
    }

    public static Boolean isValid(String source, String pattern) {
        if (StrUtils.isBlank(source) || StrUtils.isBlank(pattern)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(source);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Integer getYear(LocalDate date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return date.getYear();
    }

    public static Integer getYear() {
        return DateTimeUtils.getYear(LocalDate.now());
    }

    public static LocalDateTime getStartOfNaturalWeek(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        LocalDateTime nowDateTime = localDate.atStartOfDay();
        int dayOfWeek = localDate.getDayOfWeek().getValue();
        return nowDateTime.minusDays(dayOfWeek - 1).with(LocalTime.MIN);
    }

    public static LocalDateTime getStartOfMonth(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        LocalDateTime nowDateTime = localDate.atStartOfDay();
        return nowDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
    }

    public static Boolean judgeInTimeDuration(LocalTime time, LocalTime startTime, LocalTime endTime) {
        if (Objects.isNull(time) || Objects.isNull(startTime) || Objects.isNull(endTime)) {
            return null;
        }
        if (endTime.isAfter(startTime)) {
            return time.isAfter(startTime) && time.isBefore(endTime);
        }
        return time.isAfter(startTime) || time.isBefore(endTime);
    }

    public static Boolean judgeInTimeDurationWithBoundary(LocalTime time, LocalTime startTime, LocalTime endTime) {
        if (Objects.isNull(time) || Objects.isNull(startTime) || Objects.isNull(endTime)) {
            return null;
        }
        if (endTime.isAfter(startTime)) {
            return !time.isBefore(startTime) && !time.isAfter(endTime);
        }
        return !time.isBefore(startTime) || !time.isAfter(endTime);
    }

    public static LocalDateTime toLocalDateTimeMin(Long timestamp) {
        if (Objects.isNull(timestamp)) {
            return null;
        }
        LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(timestamp);
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTimeMin(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTimeMin(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTimeMin() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTimeMax(Long timestamp) {
        LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime(timestamp);
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MAX);
    }

    public static LocalDateTime toLocalDateTimeMax(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return localDateTime.with(LocalTime.MAX);
    }

    public static LocalDateTime toLocalDateTimeMax(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        return LocalDateTime.of(localDate, LocalTime.MAX);
    }

    public static LocalDateTime toLocalDateTimeMax() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
    }

    public static Period betweenLocalDate(LocalDate startDate, LocalDate endDate) {
        if (Objects.isNull(startDate) || Objects.isNull(endDate)) {
            return null;
        }
        return Period.between(startDate, endDate);
    }
}

