/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fengwenyi.javalib.exception.ExceptionUtils;
import com.fengwenyi.javalib.util.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final JsonMapper mapper = new JsonMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    public static void configure(JsonMapper mapper) {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        mapper.registerModule((Module)javaTimeModule);
    }

    public static <T> String string(T value) {
        if (Objects.isNull(value)) {
            return "";
        }
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error("object convert json failed, object: {}, exception: {}", value, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static String pretty(Object value) {
        if (Objects.isNull(value)) {
            return "";
        }
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error("object convert json failed, object: {}, exception: {}", value, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <T> T object(String content, Class<T> valueType) {
        if (StrUtils.isBlank(content) || Objects.isNull(valueType)) {
            return null;
        }
        try {
            return (T)mapper.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            log.error("json convert object failed, json: {}, exception: {}", (Object)content, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <T> T object(String content, TypeReference<T> valueType) {
        if (StrUtils.isBlank(content) || Objects.isNull(valueType)) {
            return null;
        }
        try {
            return (T)mapper.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            log.error("json convert object failed, json: {}, exception: {}", (Object)content, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <T> T collection(String content, Class<? extends Collection> collectionClass, Class<?> clazz) {
        if (StrUtils.isBlank(content) || Objects.isNull(collectionClass) || Objects.isNull(clazz)) {
            return null;
        }
        try {
            CollectionType valueType = mapper.getTypeFactory().constructCollectionType(collectionClass, clazz);
            return (T)mapper.readValue(content, (JavaType)valueType);
        }
        catch (JsonProcessingException e) {
            log.error("json convert collection failed, json: {}, exception: {}", (Object)content, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <T> T collection(String content, TypeReference<T> valueTypeRef) {
        if (StrUtils.isBlank(content) || Objects.isNull(valueTypeRef)) {
            return null;
        }
        try {
            return (T)mapper.readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            log.error("json convert collection failed, json: {}, exception: {}", (Object)content, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <K, V> Map<K, V> map(String json, Class<K> kClazz, Class<V> vClazz) {
        if (StrUtils.isBlank(json) || Objects.isNull(kClazz) || Objects.isNull(vClazz)) {
            return null;
        }
        try {
            MapType javaType = mapper.getTypeFactory().constructMapType(Map.class, kClazz, vClazz);
            return (Map)mapper.readValue(json, (JavaType)javaType);
        }
        catch (JsonProcessingException e) {
            log.error("json convert map failed, json: {}, exception: {}", (Object)json, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <K, V> Map<K, V> map(String json) {
        if (StrUtils.isBlank(json)) {
            return null;
        }
        try {
            return (Map)mapper.readValue(json, new TypeReference<Map<K, V>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json convert map failed, json: {}, exception: {}", (Object)json, (Object)ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static List<String> getKeys(String content) {
        JsonNode jsonNode;
        if (StrUtils.isBlank(content)) {
            return Collections.emptyList();
        }
        try {
            jsonNode = mapper.readTree(content);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (Objects.isNull(jsonNode)) {
            return Collections.emptyList();
        }
        Iterator iterator = jsonNode.fieldNames();
        ArrayList<String> keys = new ArrayList<String>();
        while (iterator.hasNext()) {
            keys.add((String)iterator.next());
        }
        return keys;
    }

    static {
        JsonUtils.configure(mapper);
    }
}

