/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.convert;

import com.fengwenyi.javalib.util.StrUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class ParamUtils {
    public static String getUrlParamsByMap(Map<String, String> data) throws UnsupportedEncodingException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> i : data.entrySet()) {
            sb.append(i.getKey()).append("=").append(URLEncoder.encode(i.getValue(), StandardCharsets.UTF_8.toString())).append("&");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public static Map<String, String> getUrlParams(String param) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StrUtils.isBlank(param)) {
            return map;
        }
        String[] params = param.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            map.put(p[0], p[1]);
        }
        return map;
    }
}

