/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class XmlUtils {
    private static final XmlMapper mapper = new XmlMapper();

    public static void configure(XmlMapper mapper) {
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        JacksonXmlModule jacksonXmlModule = new JacksonXmlModule();
        mapper.registerModule((Module)jacksonXmlModule);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        mapper.registerModule((Module)javaTimeModule);
    }

    public static <T> String string(T value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T object(String value, Class<T> valueType) {
        try {
            return (T)mapper.readValue(value, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T object(String value, TypeReference<T> valueType) {
        try {
            return (T)mapper.readValue(value, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    static {
        XmlUtils.configure(mapper);
    }
}

