/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.handle;

import com.fengwenyi.javalib.collection.CollectionUtils;
import com.fengwenyi.javalib.util.StrUtils;

public class StarHandleUtils {
    private static final int DEFAULT_PWD_LEN = 32;

    public static String ip(String ip) {
        if (StrUtils.isBlank(ip)) {
            return "";
        }
        String[] array = ip.split("\\.");
        if (CollectionUtils.isNotEmpty(array) && array.length == 4) {
            return String.format("%s.%s.*.*", array[0], array[1]);
        }
        return "";
    }

    public static String phone(String phone) {
        if (StrUtils.isBlank(phone)) {
            return "";
        }
        if (phone.length() == 11) {
            String left = StrUtils.getLeft(phone, 3);
            String right = StrUtils.getRight(phone, 4);
            String star = StrUtils.generateStar(4);
            return left + star + right;
        }
        return "";
    }

    public static String email(String email) {
        if (StrUtils.isBlank(email)) {
            return "";
        }
        int index = email.lastIndexOf("@");
        if (index > 0) {
            int indexLeft = index == 1 ? 0 : 1;
            String right = StrUtils.getRight(email, email.length() - index);
            String left = StrUtils.getLeft(email, indexLeft);
            String star = StrUtils.generateStar(index - indexLeft);
            return left + star + right;
        }
        return "";
    }

    public static String idCardNo(String idCardNo) {
        return StarHandleUtils.idCardNo(idCardNo, 3, 4);
    }

    public static String idCardNo(String idCardNo, int leftLength, int rightLength) {
        if (StrUtils.isBlank(idCardNo)) {
            return "";
        }
        if (idCardNo.length() <= leftLength + rightLength) {
            return "";
        }
        String leftString = StrUtils.getLeft(idCardNo, leftLength);
        String rightString = StrUtils.getRight(idCardNo, rightLength);
        int starLength = idCardNo.length() - leftLength - rightLength;
        String starString = StrUtils.generateStar(starLength);
        return leftString + starString + rightString;
    }

    public static String password() {
        return StrUtils.generateStar(32);
    }

    public static String password(int len) {
        return StrUtils.generateStar(len);
    }

    public static String realName(String realName) {
        if (StrUtils.isBlank(realName)) {
            return "";
        }
        if (realName.length() == 2) {
            String right = StrUtils.getRight(realName, 1);
            String star = StrUtils.generateStar(1);
            return star + right;
        }
        if (realName.length() > 2) {
            String left = StrUtils.getLeft(realName, 1);
            String right = StrUtils.getRight(realName, 1);
            String star = StrUtils.generateStar(realName.length() - 2);
            return left + star + right;
        }
        return StrUtils.generateStar(1);
    }
}

