/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http;

import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import com.fengwenyi.javalib.http.client.HttpClientFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class HttpUtils {
    public static String get(String url) {
        return HttpUtils.get(url, "");
    }

    public static String get(String url, String param) {
        try {
            Request request = Request.create(url, Request.Method.GET, param);
            return HttpUtils.execute(request, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String get(String url, Map<String, Object> param) {
        try {
            Request request = Request.create(url, Request.Method.GET, param);
            return HttpUtils.execute(request, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String postJson(String url, String param) {
        try {
            Request request = Request.create(url, Request.Method.POST, param);
            request.setParamFormat(Request.ParamFormat.JSON);
            return HttpUtils.execute(request, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String postJson(String url, Map<String, Object> param) {
        try {
            Request request = Request.create(url, Request.Method.POST, param);
            request.setParamFormat(Request.ParamFormat.JSON);
            return HttpUtils.execute(request, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String postForm(String url, Map<String, Object> param) {
        try {
            Request request = Request.create(url, Request.Method.POST, param);
            request.setParamFormat(Request.ParamFormat.FORM);
            return HttpUtils.execute(request, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Request.Option buildOption(Integer connectTimeoutSecond, Integer readTimeoutSecond, Map<String, String> headers) {
        return Request.Option.create(connectTimeoutSecond, readTimeoutSecond, headers);
    }

    public static String execute(Request request, Request.Option option) throws IOException {
        HttpUtils.check(request);
        HttpClient httpClient = HttpClientFactory.get(request.getUtil());
        Response response = httpClient.execute(request, option);
        return HttpUtils.handleResponse(response);
    }

    private static String handleResponse(Response response) throws IOException {
        if (Objects.isNull(response)) {
            return "";
        }
        String data = response.getBody();
        if (response.getCode() == 200) {
            return data;
        }
        throw new RuntimeException(data);
    }

    private static void check(Request request) {
        HttpUtils.notNull(request, "request must be not null");
        HttpUtils.notNull(request.getUrl(), "url must be not null");
        HttpUtils.notNull((Object)request.getMethod(), "method must be not null");
        HttpUtils.notNull((Object)request.getUtil(), "http util must be not null");
    }

    private static void notNull(Object param, String message) {
        if (Objects.isNull(param)) {
            throw new RuntimeException(message);
        }
    }
}

