/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.http.client.impl;

import com.fengwenyi.javalib.collection.CollectionUtils;
import com.fengwenyi.javalib.collection.MapUtils;
import com.fengwenyi.javalib.convert.JsonUtils;
import com.fengwenyi.javalib.http.Request;
import com.fengwenyi.javalib.http.Response;
import com.fengwenyi.javalib.http.client.HttpClient;
import com.fengwenyi.javalib.util.StrUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class OkHttpClient
implements HttpClient {
    @Override
    public Response execute(Request request, Request.Option option) throws IOException {
        if (CollectionUtils.isNotEmpty(request.getFileList())) {
            return this.upload(request, option);
        }
        if (Request.Method.GET == request.getMethod()) {
            return this.get(request, option);
        }
        if (Request.Method.POST == request.getMethod()) {
            return this.post(request, option);
        }
        throw new RemoteException("request method '" + request.getMethod().name() + "' not implemented");
    }

    private okhttp3.OkHttpClient client(Request.Option option) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (Objects.nonNull(option)) {
            Integer readTimeoutSecond;
            Integer connectTimeoutSecond = this.getTimeoutSecond(option.getConnectTimeoutSecond());
            if (Objects.nonNull(connectTimeoutSecond)) {
                builder.connectTimeout(Duration.ofSeconds(connectTimeoutSecond.intValue()));
            }
            if (Objects.nonNull(readTimeoutSecond = this.getTimeoutSecond(option.getReadTimeoutSecond()))) {
                builder.readTimeout(Duration.ofSeconds(readTimeoutSecond.intValue()));
            }
        }
        return builder.build();
    }

    private Response get(Request request, Request.Option option) {
        okhttp3.OkHttpClient client = this.client(option);
        okhttp3.Request httpRequest = this.buildRequest(this.getUrl(request), this.getHeaderMap(option), request.getMethod(), null);
        return this.call(client, httpRequest);
    }

    private Response post(Request request, Request.Option option) {
        okhttp3.OkHttpClient client = this.client(option);
        Request.ParamFormat paramFormat = request.getParamFormat();
        Map<String, Object> param = request.getParam();
        RequestBody requestBody = null;
        if (MapUtils.isNotEmpty(param)) {
            if (param.containsKey("__default__")) {
                String paramStr = param.get("__default__") + "";
                if (Request.ParamFormat.JSON == paramFormat) {
                    requestBody = this.buildJsonRequestBody(paramStr);
                }
            } else if (Request.ParamFormat.JSON == paramFormat) {
                requestBody = this.buildJsonRequestBody(JsonUtils.string(param));
            } else if (Request.ParamFormat.FORM == paramFormat) {
                requestBody = this.buildFormRequestBody(param);
            }
        }
        okhttp3.Request httpRequest = this.buildRequest(this.getUrl(request), this.getHeaderMap(option), request.getMethod(), requestBody);
        return this.call(client, httpRequest);
    }

    private RequestBody buildJsonRequestBody(String param) {
        return RequestBody.create((String)param, (MediaType)MediaType.parse((String)"application/json"));
    }

    private RequestBody buildFormRequestBody(Map<String, Object> param) {
        FormBody.Builder builder = new FormBody.Builder();
        if (MapUtils.isNotEmpty(param)) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                builder.add(entry.getKey(), entry.getValue() + "");
            }
        }
        return builder.build();
    }

    private okhttp3.Request buildRequest(String url, Map<String, String> headers, Request.Method requestMethod, RequestBody requestBody) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (Objects.nonNull(requestBody)) {
            if (Request.Method.POST == requestMethod) {
                builder.post(requestBody);
            } else if (Request.Method.PUT == requestMethod) {
                builder.put(requestBody);
            }
        }
        return builder.build();
    }

    private Response call(okhttp3.OkHttpClient client, okhttp3.Request request) {
        Response response;
        block8: {
            Call call = client.newCall(request);
            okhttp3.Response httpResponse = call.execute();
            try {
                response = this.convertResponse(httpResponse);
                if (httpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            httpResponse.close();
        }
        return response;
    }

    private Response convertResponse(okhttp3.Response httpResponse) throws IOException {
        if (Objects.isNull(httpResponse)) {
            throw new RuntimeException("http response null");
        }
        Response response = new Response();
        response.setCode(httpResponse.code());
        response.setMsg(httpResponse.message());
        ResponseBody responseBody = httpResponse.body();
        if (Objects.nonNull(responseBody)) {
            response.setBody(responseBody.string());
        }
        return response;
    }

    private HttpUrl getHttpUrl(Request request) {
        HttpUrl.Builder builder = HttpUrl.get((String)request.getUrl()).newBuilder();
        if (Request.Method.GET == request.getMethod() && MapUtils.isNotEmpty(request.getParam())) {
            if (request.getParam().containsKey("__default__")) {
                builder.addPathSegment(request.getParam().get("__default__") + "");
            } else {
                for (Map.Entry<String, Object> entry : request.getParam().entrySet()) {
                    builder.addQueryParameter(entry.getKey(), entry.getValue() + "");
                }
            }
        }
        return builder.build();
    }

    private String getUrl(Request request) {
        String result;
        if (StrUtils.isBlank(request.getUrl())) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder url = new StringBuilder(request.getUrl());
        if (Request.Method.GET == request.getMethod()) {
            if (!url.toString().contains("?")) {
                url.append("?");
            }
            if (MapUtils.isNotEmpty(request.getParam())) {
                if (request.getParam().containsKey("__default__")) {
                    url.append(request.getParam().get("__default__"));
                } else {
                    for (Map.Entry<String, Object> entry : request.getParam().entrySet()) {
                        url.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    }
                }
            }
        }
        if ((result = url.toString()).endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Response upload(Request request, Request.Option option) {
        okhttp3.OkHttpClient client = this.client(option);
        MediaType mediaType = MediaType.parse((String)"multipart/form-data; charset=utf-8");
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        List<Request.FileBo> fileList = request.getFileList();
        for (Request.FileBo fileBo : fileList) {
            if (Objects.isNull(fileBo.getFile())) {
                throw new RuntimeException("upload failed: file must not be null");
            }
            if (StrUtils.isBlank(fileBo.getFileName())) {
                fileBo.setFileName(fileBo.getFile().getName());
            }
            bodyBuilder.addFormDataPart(fileBo.getParamName(), fileBo.getFileName(), RequestBody.create((MediaType)mediaType, (File)fileBo.getFile()));
        }
        if (MapUtils.isNotEmpty(request.getParam())) {
            for (Map.Entry entry : request.getParam().entrySet()) {
                bodyBuilder.addFormDataPart((String)entry.getKey(), entry.getValue() + "");
            }
        }
        MultipartBody requestBody = bodyBuilder.build();
        okhttp3.Request request2 = this.buildRequest(this.getUrl(request), this.getHeaderMap(option), request.getMethod(), (RequestBody)requestBody);
        return this.call(client, request2);
    }

    private Map<String, String> getHeaderMap(Request.Option option) {
        if (Objects.isNull(option)) {
            return null;
        }
        return option.getHeaders();
    }
}

