/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.javalib.util;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class StrUtils {
    public static final String BLANK = "";

    public static boolean isBlank(String str) {
        if (Objects.isNull(str)) {
            return true;
        }
        if ((str = str.trim()).isEmpty()) {
            return true;
        }
        if ("null".equalsIgnoreCase(str)) {
            return true;
        }
        return str.length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !StrUtils.isBlank(str);
    }

    public static String autoFill(Integer source, Integer length) {
        if (source == null || length == null || (source + BLANK).length() >= length) {
            return source + BLANK;
        }
        return String.format("%0" + length + "d", source);
    }

    public static String autoFill(String source, Integer length, String str, Boolean isRight) {
        if (source == null || length == null || source.length() >= length) {
            return source;
        }
        if (StrUtils.isBlank(str)) {
            str = "0";
        }
        if (isRight == null) {
            isRight = false;
        }
        int count = source.length();
        StringBuilder sb = new StringBuilder(length);
        if (isRight.booleanValue()) {
            sb.append(source);
        }
        int size = length - count;
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        if (!isRight.booleanValue()) {
            sb.append(source);
        }
        return sb.toString();
    }

    public static boolean hasOnlyNum(String str) {
        if (StrUtils.isBlank(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static String getRandomString(int length) {
        StringBuilder result = new StringBuilder();
        char[] str = "0123456789abcdefghijkmlnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        for (int i = 0; i < length; ++i) {
            int index = (int)(Math.random() * (double)str.length);
            result.append(str[index]);
        }
        return result.toString();
    }

    public static String removeStart(String str, String remove) {
        if (StrUtils.isNotBlank(str) && StrUtils.isNotBlank(remove)) {
            return str.startsWith(remove) ? str.substring(remove.length()) : str;
        }
        return str;
    }

    public static String generateStar(int length) {
        StringJoiner sj = new StringJoiner(BLANK, BLANK, BLANK);
        for (int i = 0; i < length; ++i) {
            sj.add("*");
        }
        return sj.toString();
    }

    public static String getLeft(String source, int length) {
        if (StrUtils.isBlank(source) || length < 1) {
            return BLANK;
        }
        if (length > source.length()) {
            length = source.length();
        }
        return source.substring(0, length);
    }

    public static String getRight(String source, int length) {
        if (StrUtils.isBlank(source) || length < 1) {
            return BLANK;
        }
        if (length > source.length()) {
            length = source.length();
        }
        return source.substring(source.length() - length);
    }

    public static String substringAfter(String content, String prefix) {
        if (StrUtils.isBlank(content)) {
            return BLANK;
        }
        if (StrUtils.isBlank(prefix)) {
            return content;
        }
        return content.substring(prefix.length());
    }

    public static String lowerCaseFirst(String content) {
        if (StrUtils.isBlank(content)) {
            return BLANK;
        }
        String first = content.substring(0, 1);
        String after = content.substring(1);
        return first.toLowerCase() + after;
    }
}

