/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.api.result;

import com.fengwenyi.api.result.IBuilder;
import com.fengwenyi.api.result.ListTemplate;
import java.util.List;

public class PageTemplate<T>
extends ListTemplate<T> {
    private static final long serialVersionUID = -4253922988693797927L;
    private Long current;
    private Integer pageSize;
    private Long totalRow;
    private Long totalPage;

    public PageTemplate() {
    }

    public PageTemplate(Long current, Integer pageSize, Long totalRow, Long totalPage, List<T> content) {
        this.current = current;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
        this.totalPage = totalPage;
        super.setContent(content);
    }

    public Long getCurrent() {
        return this.current;
    }

    public PageTemplate<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PageTemplate<T> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getTotalRow() {
        return this.totalRow;
    }

    public PageTemplate<T> setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        return this;
    }

    public Long getTotalPages() {
        return this.totalPage;
    }

    public PageTemplate<T> setTotalPage(long totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public String toString() {
        return "PageTemplate{current=" + this.current + ", pageSize=" + this.pageSize + ", totalRow=" + this.totalRow + ", totalPage=" + this.totalPage + ", content=" + this.getContent() + '}';
    }

    public static class Builder<T>
    implements IBuilder<PageTemplate<T>> {
        private final PageTemplate<T> pageTemplate = new PageTemplate();

        public Builder<T> current(long current) {
            ((PageTemplate)this.pageTemplate).current = current;
            return this;
        }

        public Builder<T> pageSize(int pageSize) {
            ((PageTemplate)this.pageTemplate).pageSize = pageSize;
            return this;
        }

        public Builder<T> totalRow(long totalRow) {
            ((PageTemplate)this.pageTemplate).totalRow = totalRow;
            return this;
        }

        public Builder<T> totalPage(long totalPage) {
            ((PageTemplate)this.pageTemplate).totalPage = totalPage;
            return this;
        }

        public Builder<T> content(List<T> content) {
            this.pageTemplate.setContent(content);
            return this;
        }

        @Override
        public PageTemplate<T> build() {
            return this.pageTemplate;
        }
    }
}

