/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.api.result;

import com.fengwenyi.api.result.IResult;
import com.fengwenyi.api.result.ResultHeader;
import com.fengwenyi.api.result.StringUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

public class ResultTemplate<T>
implements Serializable {
    private static final long serialVersionUID = 2694678370842576448L;
    private String code;
    private String msg;
    private Boolean success = Boolean.FALSE;
    private ResultHeader header;
    private T body;
    private String date = LocalDateTime.now().toString();
    private static final IResult SUCCESS = IResult.Default.SUCCESS;
    private static final IResult ERROR = IResult.Default.ERROR;

    public static <T> ResultTemplate<T> success() {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(SUCCESS.getCode()).setMsg(SUCCESS.getMsg());
    }

    public static <T> ResultTemplate<T> success(T body) {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(SUCCESS.getCode()).setMsg(SUCCESS.getMsg()).setBody(body);
    }

    public static <T> ResultTemplate<T> fail() {
        return new ResultTemplate<T>().setCode(ERROR.getCode()).setMsg(ERROR.getMsg());
    }

    public static <T> ResultTemplate<T> fail(String msg) {
        msg = StringUtils.isBlank(msg) ? ERROR.getMsg() : msg;
        return new ResultTemplate<T>().setCode(ERROR.getCode()).setMsg(msg);
    }

    public static <T> ResultTemplate<T> fail(IResult returnCode) {
        return new ResultTemplate<T>().setCode(returnCode.getCode()).setMsg(returnCode.getMsg());
    }

    public static <T> ResultTemplate<T> fail(IResult returnCode, String msg) {
        msg = StringUtils.isBlank(msg) ? returnCode.getMsg() : msg;
        return new ResultTemplate<T>().setCode(returnCode.getCode()).setMsg(msg);
    }

    public static <T> ResultTemplate<T> fail(String code, String msg) {
        return new ResultTemplate<T>().setCode(code).setMsg(msg);
    }

    public String getCode() {
        return this.code;
    }

    public ResultTemplate<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public ResultTemplate<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public ResultTemplate<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResultHeader getHeader() {
        return this.header;
    }

    public ResultTemplate<T> setHeader(ResultHeader header) {
        this.header = header;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public ResultTemplate<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public String getDate() {
        return this.date;
    }

    public ResultTemplate<T> setDate(LocalDateTime date) {
        if (Objects.nonNull(date)) {
            this.date = date.toString();
        }
        return this;
    }

    public ResultTemplate<T> setDate(String date) {
        this.date = date;
        return this;
    }

    public String toString() {
        return "ResultTemplate{code='" + this.code + '\'' + ", msg='" + this.msg + '\'' + ", success=" + this.success + ", header=" + this.header + ", body=" + this.body + ", date=" + this.date + '}';
    }
}

