/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.utils;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.TransService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FixedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class TransUtil {
    private static final Logger log = LoggerFactory.getLogger(TransUtil.class);
    public static boolean transResultMap = false;
    private static Map<Class, Class> proxyClassMap = new ConcurrentHashMap<Class, Class>();
    private static Map<Class, Set<String>> proxyClassFieldMap = new ConcurrentHashMap<Class, Set<String>>();
    private static Set<String> notTransClassNames = new HashSet<String>();

    public static Collection transBatch(Object object, TransService transService, boolean isProxy, ArrayList<Object> hasTransObjs, Set<String> includeFields, Set<String> excludeFields) throws IllegalAccessException, InstantiationException {
        Collection param = (Collection)object;
        if (param == null) {
            return null;
        }
        if (param.isEmpty() || param.iterator().next() == null) {
            return param;
        }
        boolean isVo = false;
        if (param.iterator().next() instanceof VO) {
            transService.transMore(new ArrayList(param), includeFields, excludeFields);
            for (Object tempObject : param) {
                TransUtil.transFields(tempObject, transService, isProxy, hasTransObjs, includeFields, excludeFields);
            }
            isVo = true;
        } else {
            for (Object tempObject : param) {
                TransUtil.transOne(tempObject, transService, isProxy, hasTransObjs, includeFields, excludeFields);
            }
        }
        if (!isProxy || !isVo) {
            return (Collection)object;
        }
        AbstractCollection result = null;
        if (param instanceof List) {
            result = new ArrayList();
        } else if (param instanceof Set) {
            result = new HashSet();
        } else {
            return param;
        }
        for (Object vo : param) {
            if (TransUtil.contains(hasTransObjs, vo)) continue;
            hasTransObjs.add(vo);
            result.add(TransUtil.createProxyVo((VO)vo));
        }
        return result;
    }

    public static void mergeTransSubVo(VO vo, Collection<? extends VO> vos, Map<Class, List<? extends VO>> voMap) {
        ArrayList<Object> hasVoList = null;
        if (vo == null) {
            vo = vos.iterator().next();
        }
        List<Object> list = hasVoList = voMap.containsKey(vo.getClass()) ? voMap.get(vo.getClass()) : new ArrayList<Object>();
        if (vos != null) {
            hasVoList.addAll(vos);
        } else {
            hasVoList.add(vo);
        }
        voMap.put(vo.getClass(), hasVoList);
    }

    private static boolean contains(List<Object> list, Object obj) {
        for (Object o : list) {
            if (o != obj) continue;
            return true;
        }
        return false;
    }

    public static Object transOne(Object object, TransService transService, boolean isProxy, ArrayList<Object> hasTransObjs, Set<String> includeFields, Set<String> excludeFields) throws IllegalAccessException, InstantiationException {
        if (object == null) {
            return null;
        }
        if (TransUtil.contains(hasTransObjs, object)) {
            return object;
        }
        hasTransObjs.add(object);
        boolean isVo = false;
        if (transResultMap && object instanceof Map) {
            Map tempMap = (Map)object;
            for (Object key : tempMap.keySet()) {
                Object mapValue = tempMap.get(key);
                try {
                    tempMap.put(key, TransUtil.transOne(mapValue, transService, isProxy, hasTransObjs, includeFields, excludeFields));
                }
                catch (Exception exception) {}
            }
            return object;
        }
        if (object instanceof VO) {
            transService.transOne((VO)object, includeFields, excludeFields);
            TransUtil.transFields(object, transService, isProxy, hasTransObjs, includeFields, excludeFields);
            isVo = true;
        } else {
            if (object instanceof Collection) {
                return TransUtil.transBatch(object, transService, isProxy, hasTransObjs, includeFields, excludeFields);
            }
            if (object.getClass().getName().startsWith("java.")) {
                return object;
            }
            TransUtil.transFields(object, transService, isProxy, hasTransObjs, includeFields, excludeFields);
        }
        return isProxy && isVo ? TransUtil.createProxyVo((VO)object) : object;
    }

    public static void transFields(Object object, TransService transService, boolean isProxy, ArrayList<Object> hasTransObjs, Set<String> includeFields, Set<String> excludeFields) throws IllegalAccessException, InstantiationException {
        if (object == null) {
            return;
        }
        Object tempObj = null;
        if (object instanceof Map) {
            return;
        }
        if (notTransClassNames.contains(object.getClass().getName())) {
            return;
        }
        List fields = ReflectUtils.getAllField((Object)object);
        for (Field field : fields) {
            if (Modifier.isFinal(field.getModifiers()) && (object.getClass().getName().contains("bs") || object.getClass().getName().contains("ejlchina"))) {
                List tempList;
                field.setAccessible(true);
                tempObj = field.get(object);
                if (Objects.nonNull(tempObj) && tempObj instanceof List && !CollectionUtils.isEmpty((Collection)(tempList = (List)tempObj)) && Objects.nonNull(tempList.get(0)) && tempList.get(0) instanceof VO) {
                    Collection transResult = TransUtil.transBatch(tempObj, transService, isProxy, hasTransObjs, includeFields, excludeFields);
                    tempList.clear();
                    tempList.addAll(transResult);
                }
            }
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            tempObj = field.get(object);
            try {
                field.set(object, TransUtil.transOne(tempObj, transService, isProxy, hasTransObjs, includeFields, excludeFields));
            }
            catch (Exception e) {
                if (e.getClass().getName().contains("java.lang.reflect")) {
                    log.error("\u68c0\u6d4b\u5230\u53cd\u5c04\u9519\u8bef{}\uff0c\u6b64\u7c7b\u540e\u9762\u7a0b\u5e8f\u4e0d\u5728\u8d70\u7ffb\u8bd1\u903b\u8f91:" + object.getClass().getName(), e.getClass());
                    notTransClassNames.add(object.getClass().getName());
                    return;
                }
                log.error("\u5982\u679c\u5b57\u6bb5set\u9519\u8bef\uff0c\u8bf7\u53cd\u9988\u7ed9easytrans\u5f00\u53d1\u8005", (Throwable)e);
            }
        }
    }

    private static boolean validProxyClass(Set<String> propertes, Class clazz) {
        Set<String> fieldSet = proxyClassFieldMap.get(clazz);
        return fieldSet.containsAll(propertes);
    }

    public static Class genNewClass(VO vo) {
        try {
            Class targetClass = proxyClassMap.get(vo.getClass());
            boolean isGenNewClass = true;
            if (targetClass != null && TransUtil.validProxyClass(vo.getTransMap().keySet(), targetClass)) {
                isGenNewClass = false;
            }
            if (isGenNewClass) {
                AnnotationDescription jacksonIgnore = AnnotationDescription.Builder.ofType(JsonIgnore.class).build();
                AnnotationDescription fastJsonIgnore = AnnotationDescription.Builder.ofType(JSONField.class).define("serialize", false).build();
                DynamicType.Builder.MethodDefinition builder = new ByteBuddy().subclass(vo.getClass()).name(vo.getClass().getSimpleName() + "DynamicTypeBuilder" + StringUtil.getUUID()).defineMethod("getTransMap", Map.class, 1).intercept(FixedValue.nullValue()).annotateMethod(new AnnotationDescription[]{jacksonIgnore, fastJsonIgnore});
                for (String property : vo.getTransMap().keySet()) {
                    builder = builder.defineField(property, String.class, 1);
                }
                targetClass = builder.make().load(ClassUtils.getDefaultClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
                proxyClassMap.put(vo.getClass(), targetClass);
                proxyClassFieldMap.put(targetClass, vo.getTransMap().keySet());
            }
            return targetClass;
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                log.error("\u751f\u6210\u65b0class\u9519\u8bef\uff0c\u76ee\u524d\u4e0d\u652f\u6301JDK17\uff0c\u8bf7\u5173\u95ed\u5e73\u94fa\u6a21\u5f0f: easy-trans.is-enable-tile \u8bbe\u7f6e\u4e3afalse");
            } else {
                log.error("\u751f\u6210\u65b0class\u9519\u8bef", (Throwable)e);
            }
            return null;
        }
    }

    public static Object createProxyVo(VO vo) {
        if (vo == null || vo.getTransMap() == null) {
            return vo;
        }
        try {
            Class clazz = TransUtil.genNewClass(vo);
            Object newObject = clazz.newInstance();
            if (newObject == null) {
                return vo;
            }
            BeanUtils.copyProperties((Object)vo, newObject);
            for (String property : vo.getTransMap().keySet()) {
                ReflectUtils.setValue(newObject, (String)property, (Object)ConverterUtils.toString(vo.getTransMap().get(property)));
            }
            return newObject;
        }
        catch (Exception e) {
            log.error("easy trans \u8d4b\u503c\u9519\u8bef", (Throwable)e);
            return vo;
        }
    }
}

