/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.cache.service.BothCacheService;
import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.utils.JsonUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.anno.UnTrans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.fi.LocaleGetter;
import com.fhs.trans.listener.TransMessageListener;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.TransService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class DictionaryTransService
implements ITransTypeService,
InitializingBean {
    private static final String UNTRANS_PREFIX = "un_trans:";
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryTransService.class);
    @Autowired
    private BothCacheService<String> bothCacheService;
    @Autowired(required=false)
    private RedisCacheService<String> redisCacheService;
    private boolean isOpenI18n;
    private LocaleGetter localeGetter;
    @Value(value="${easy-trans.dict-use-redis:false}")
    private boolean isUseRedis;

    public void refreshCache(String dictGroupCode, Map<String, String> dicMap) {
        if (this.isUseRedis && this.redisCacheService == null) {
            throw new RuntimeException("\u4f7f\u7528redis \u8bf7\u5c06 easy-trans.is-enable-redis \u8bbe\u7f6e\u4e3atrue");
        }
        dicMap.keySet().forEach(dictCode -> {
            this.bothCacheService.put(dictGroupCode + "_" + dictCode, (String)dicMap.get(dictCode), false);
            this.bothCacheService.put(UNTRANS_PREFIX + dictGroupCode + "_" + (String)dicMap.get(dictCode), (String)dictCode, false);
        });
    }

    public void refreshCacheAndNoticeOtherService(String dictGroupCode, Map<String, String> dicMap) {
        this.bothCacheService.remove(dictGroupCode, false);
        this.refreshCache(dictGroupCode, dicMap);
        this.noticeOtherService(dictGroupCode);
    }

    public void removeDictGroupAndNoticeOtherService(String dictGroupCode) {
        this.bothCacheService.remove(dictGroupCode, false);
        this.noticeOtherService(dictGroupCode);
    }

    public void refreshDictItem(String dictGroupCode, String dictCode, String dictTransResult) {
        this.bothCacheService.remove(dictGroupCode + '_' + dictCode, false);
        HashMap<String, String> dicMap = new HashMap<String, String>();
        dicMap.put(dictCode, dictTransResult);
        this.refreshCache(dictGroupCode, dicMap);
        this.noticeOtherService(dictGroupCode + '_' + dictCode);
    }

    public void noticeOtherService(String dictGroupCode) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("transType", "dictionary");
        body.put("dictGroupCode", dictGroupCode);
        this.redisCacheService.convertAndSend("trans", JsonUtils.map2json(body));
    }

    public void clearCache(Map<String, Object> messageMap) {
        String dictGroupCode = StringUtil.toString(messageMap.get("dictGroupCode"));
        if (!StringUtils.isEmpty((Object)dictGroupCode)) {
            this.bothCacheService.remove(dictGroupCode, true);
            this.bothCacheService.remove(UNTRANS_PREFIX + dictGroupCode, true);
        }
    }

    public Map<String, String> getDictionaryTransMap() {
        return this.bothCacheService.getLocalCacheMap();
    }

    @Override
    public void unTransOne(Object obj, List<Field> toTransList) {
        for (Field tempField : toTransList) {
            tempField.setAccessible(true);
            UnTrans unTrans = tempField.getAnnotation(UnTrans.class);
            try {
                String value = this.bothCacheService.get(UNTRANS_PREFIX + unTrans.dict() + "_" + ReflectUtils.getDeclaredField(obj.getClass(), (String)unTrans.refs()[0]).get(obj));
                this.setValue(obj, tempField.getName(), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void unTransMore(List objList, List<Field> toTransList) {
        for (Object obj : objList) {
            this.unTransOne(obj, toTransList);
        }
    }

    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        Trans tempTrans = null;
        for (Field tempField : toTransList) {
            String transResult;
            tempField.setAccessible(true);
            tempTrans = tempField.getAnnotation(Trans.class);
            String dicCodes = StringUtil.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
            if (dicCodes.contains("[")) {
                dicCodes = dicCodes.replace("[", "").replace("]", "");
            }
            if (dicCodes.contains(",")) {
                dicCodes = dicCodes.replace(" ", "");
            }
            String[] dicCodeArray = dicCodes.split(",");
            String key = tempTrans.key().contains("KEY_") ? StringUtil.toString(ReflectUtils.getValue((Object)obj, (String)tempTrans.key().replace("KEY_", ""))) : tempTrans.key();
            ArrayList<String> dicCodeList = new ArrayList<String>(1);
            for (String dicCode : dicCodeArray) {
                if (StringUtil.isEmpty(dicCode)) continue;
                dicCodeList.add(this.bothCacheService.get(this.getMapKey(key.trim(), dicCode)));
            }
            String string = transResult = dicCodeList.size() > 0 ? StringUtil.getStrForIn(dicCodeList, false) : "";
            if (obj.getTransMap() == null || this.setRef(tempTrans, obj, transResult)) continue;
            obj.getTransMap().put(tempField.getName() + "Name", transResult);
        }
    }

    public String getMapKey(String dictGroupCode, String dictCode) {
        if (this.isOpenI18n) {
            return dictGroupCode + "_" + dictCode + "_" + this.localeGetter.getLanguageTag();
        }
        return dictGroupCode + "_" + dictCode;
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        for (VO vO : objList) {
            this.transOne(vO, toTransList);
        }
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("dictionary", this);
        TransMessageListener.regTransRefresher("dictionary", this::clearCache);
    }

    public void openI18n(LocaleGetter localeGetter) {
        this.isOpenI18n = true;
        this.localeGetter = localeGetter;
    }

    public void makeUseRedis() {
        this.isUseRedis = true;
        this.bothCacheService.setUseRedis(true);
        if (this.redisCacheService == null) {
            throw new RuntimeException("\u4f7f\u7528redis \u8bf7\u5c06 easy-trans.is-enable-redis \u8bbe\u7f6e\u4e3atrue");
        }
    }
}

