/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.common.utils;

import com.fhs.common.utils.CheckUtils;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.core.trans.util.ReflectUtils;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final int LEFT_SPACE = 0;
    public static final int RIGHT_SPACE = 1;
    public static final int TRUNC_LEFT = 0;
    public static final int TRUNC_RIGHT = 1;

    public static String removeSpecialchar(String text, String split) {
        if (null != text && !"".equals(text.trim())) {
            return text.replaceAll(split, "");
        }
        return "";
    }

    public static List<String> getContentBySplit(String split, String content) {
        ArrayList<String> list = new ArrayList<String>();
        if (content.contains(split)) {
            String[] htmStr;
            for (String htm : htmStr = content.split(split)) {
                list.add(htm);
            }
        }
        return list;
    }

    public String getContentByKeyWord(String keyword, String content) {
        if (content.contains(keyword)) {
            return content;
        }
        return "";
    }

    public String getContentByCut(String head, String foot, String content) {
        int beginIndex = content.indexOf(head);
        int diff = head.length();
        int endIndex = content.indexOf(foot);
        String htmStr = "";
        if (beginIndex > 0 && endIndex > 0) {
            htmStr = content.substring(beginIndex + diff, endIndex);
        }
        return htmStr;
    }

    public static String removeEsc(String src) {
        String string = src.replaceAll("\\\\/", "/").replaceAll("\\\\\"", "\"").replaceAll("\\\\t", "").replaceAll("\\\\n", "");
        return string;
    }

    public static String decodeUnicode(String dataStr) {
        int start = 0;
        int end = 0;
        StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            if ((start = dataStr.indexOf("\\u", start)) == -1) {
                buffer.append(dataStr.substring(end));
                continue;
            }
            buffer.append(dataStr.substring(end, start));
            end = start + 6;
            String charStr = "";
            charStr = dataStr.substring(start + 2, end);
            char letter = '0';
            try {
                letter = (char)Integer.parseInt(charStr, 16);
                buffer.append(new Character(letter).toString());
            }
            catch (NumberFormatException e) {
                buffer.append("\\u" + charStr);
            }
            start = end;
        }
        return buffer.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String leftTrim(String str) {
        byte ch;
        if (str == null || "" == str) {
            return "";
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = str.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        int index = 0;
        while ((ch = bytes[index]) == 32) {
            ++index;
        }
        return str.substring(index);
    }

    public static String rightTrim(String str) {
        byte ch;
        if (str == null) {
            return "";
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = str.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        int index = StringUtil.length(str);
        if (index == 0) {
            return "";
        }
        --index;
        while ((ch = bytes[index]) == 32 && --index >= 0) {
        }
        return str.substring(0, index + 1);
    }

    public static String allTrim(String str) {
        if (str == null) {
            return "";
        }
        String tmp = str.trim();
        if (tmp.equals("")) {
            return "";
        }
        int idx = 0;
        int len = 0;
        len = tmp.length();
        idx = tmp.indexOf(" ");
        while (idx > 0) {
            tmp = tmp.substring(0, idx) + tmp.substring(idx + 1, len);
            idx = tmp.indexOf(" ");
            len = tmp.length();
        }
        return tmp;
    }

    public static String trim(String orin) {
        return null == orin ? "" : orin.trim();
    }

    public static int length(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return new String(str.getBytes("GBK"), "8859_1").length();
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public static byte[] getBytes(String str) {
        try {
            return str.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static String checkSqlValue(String str) {
        if (str == null) {
            return str;
        }
        String cstr = str;
        int pos = cstr.indexOf("'");
        while (pos >= 0) {
            cstr = cstr.substring(0, pos + 1) + "'" + cstr.substring(pos + 1);
            pos = cstr.indexOf("'", pos + 2);
        }
        return cstr;
    }

    public static String[] stringTokenizer(String str, String delim, int length) {
        StringTokenizer stk = new StringTokenizer(str, delim);
        String[] returnStr = new String[length];
        int i = 0;
        while (stk.hasMoreTokens()) {
            returnStr[i] = stk.nextToken();
            ++i;
        }
        return returnStr;
    }

    public static List<String> stringTokenizer(String str, String delim) {
        StringTokenizer stk = new StringTokenizer(str, delim);
        ArrayList<String> returnStr = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            returnStr.add(stk.nextToken());
        }
        return returnStr;
    }

    public static boolean isEqualAfterTrim(String src, String dest) {
        if (null == src || null == dest) {
            return false;
        }
        return StringUtil.trim(src).equals(StringUtil.trim(dest));
    }

    public static String getMethodName(String str, String filed) {
        String frist = filed.substring(0, 1);
        String temp = filed.replaceFirst(frist, frist.toUpperCase());
        return str + temp;
    }

    public static String getResult(String type) {
        StringBuffer sb = new StringBuffer(type);
        sb.append("_show");
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj != null) {
            return String.valueOf(obj);
        }
        return "";
    }

    public static String toString(Object obj, String defaultVal) {
        if (obj != null) {
            return String.valueOf(obj);
        }
        return defaultVal;
    }

    public static String getStrForIntegerIn(List<String> list) {
        return StringUtil.getStrForIn(list, false);
    }

    public static String getStrForIn(Collection collection, boolean isAddMarks) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String appendMarks = isAddMarks ? "'" : "";
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            result.append(",").append(appendMarks + ConverterUtils.toString(iter.next()) + appendMarks);
        }
        return result.length() > 0 ? result.substring(1) : "-10000";
    }

    public static String getStrForIntegerIn(List<? extends Object> list, String fileName) {
        ArrayList<String> strList = new ArrayList<String>();
        for (Object object : list) {
            strList.add(StringUtil.toString(ReflectUtils.getValue((Object)object, (String)fileName)));
        }
        return StringUtil.getStrForIn(strList, false);
    }

    public static String getStrIn(String str) {
        if (str == null || str.length() < 3) {
            return "0";
        }
        str = str.substring(1);
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean validtIsChinese(String param) {
        Pattern pattern = Pattern.compile("^[0-9a-zA-Z_]+$");
        Matcher matcher = pattern.matcher(param);
        return !matcher.matches();
    }

    public static String decodeString(String str) {
        return str;
    }

    public static boolean isInteger(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return Pattern.compile("^\\d+$").matcher(str).matches();
    }

    public static String deleteLastSubstr(String oldStr, String subStr) {
        int ogrStrLength = oldStr.length();
        int subStrLength = subStr.length();
        if (oldStr.endsWith(subStr)) {
            oldStr = oldStr.substring(0, ogrStrLength - subStrLength);
        }
        return oldStr;
    }

    public static String formatCountWith0(String prefix, String format, Integer count) {
        String str = prefix + String.format(format, count);
        return str;
    }

    public static String formatString2empty(String string) {
        String returnString = "";
        if (string == null) {
            return returnString;
        }
        return string;
    }

    public static String digitUppercase(double num) {
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[] unit1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
        String[] unit2 = new String[]{"\u5706", "\u4e07", "\u4ebf", "\u4e07\u4ebf"};
        DecimalFormat df = new DecimalFormat("0.00");
        String value = df.format((double)Math.round(num * 100.0) / 100.0);
        String[] value1 = value.split("\\.");
        String head = value1[0];
        String end = value1[1];
        String endMoney = "";
        String headMoney = "";
        if ("00".equals(end)) {
            endMoney = "\u6574";
        } else {
            if (!end.substring(0, 1).equals("0")) {
                endMoney = endMoney + digit[Integer.valueOf(end.substring(0, 1))] + "\u89d2";
            } else if (end.substring(0, 1).equals("0") && !end.substring(1, 2).equals("0")) {
                endMoney = endMoney + "\u96f6";
            }
            if (!end.substring(1, 2).equals("0")) {
                endMoney = endMoney + digit[Integer.valueOf(end.substring(1, 2))] + "\u5206";
            }
        }
        char[] chars = head.toCharArray();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        boolean zeroKeepFlag = false;
        int vidxtemp = 0;
        for (int i = 0; i < chars.length; ++i) {
            int idx = (chars.length - 1 - i) % 4;
            int vidx = (chars.length - 1 - i) / 4;
            String s = digit[Integer.valueOf(String.valueOf(chars[i]))];
            if (!"\u96f6".equals(s)) {
                headMoney = headMoney + s + unit1[idx] + unit2[vidx];
                zeroKeepFlag = false;
            } else if (i == chars.length - 1 || map.get("zero" + vidx) != null) {
                headMoney = headMoney + "";
            } else {
                headMoney = headMoney + s;
                zeroKeepFlag = true;
                map.put("zero" + vidx, true);
            }
            if (vidxtemp != vidx || i == chars.length - 1) {
                headMoney = headMoney.replaceAll(unit2[vidx], "");
                headMoney = headMoney + unit2[vidx];
            }
            if (!zeroKeepFlag || (chars.length - 1 - i) % 4 != 0) continue;
            headMoney = headMoney.replaceAll("\u96f6", "");
        }
        String upperName = headMoney + endMoney;
        if (upperName.equals("\u5706\u6574")) {
            return "\u96f6\u5706\u6574";
        }
        if (upperName.startsWith("\u5706\u96f6")) {
            return upperName.substring(2);
        }
        if (upperName.startsWith("\u5706")) {
            return upperName.substring(1);
        }
        return upperName;
    }

    public static String join(Collection<?> coll, String split, String defaultStr) {
        if (coll == null || coll.isEmpty()) {
            return defaultStr;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object s : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(split);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(Collection<?> coll, String split) {
        return StringUtil.join(coll, split, "");
    }

    public static String join(String[] array, String split) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String subNoticeTitle(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        if (str.length() > 10) {
            str = str.substring(0, 10) + "...";
        }
        return str;
    }

    public static String useQuotesWrapValue(Object str) {
        if (str == null || "".equals(str)) {
            return "''";
        }
        str = "'" + str + "'";
        return str.toString();
    }

    public static String matchFront(String split, String content) {
        String front = "";
        if (!CheckUtils.isNullOrEmpty(content)) {
            Integer endIndex = content.indexOf(split);
            front = content.substring(0, endIndex);
        }
        return front;
    }

    public static String matchBehind(String split, String content) {
        String behind = "";
        if (!CheckUtils.isNullOrEmpty(content)) {
            Integer endIndex = content.indexOf(split);
            behind = content.substring(endIndex + 1);
        }
        return behind;
    }

    public static String trimAllSplit(String str, String splitStr) {
        if (str.startsWith(splitStr)) {
            str = str.substring(1);
        }
        if (str.endsWith(splitStr)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static List<Integer> StringToInt(String str) {
        String[] arrs = str.split(",");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < arrs.length; ++i) {
            result.add(ConverterUtils.toInt(arrs[i]));
        }
        return result;
    }

    public static String formatFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String fileNameInvaildPattern = "[\\/:\\*\\?\"<>|]";
        String vaildFileName = fileName.replaceAll(fileNameInvaildPattern, "");
        return vaildFileName;
    }

    public static String formatOrderNumber(String date, int number) {
        return StringUtil.formatCountWith0(date, "%08d", number);
    }

    public static Integer formatShortNumber(int number) {
        int source = 100000;
        int target = Integer.valueOf(StringUtil.formatCountWith0("", "%06d", number));
        return source + target;
    }

    public static String formatCheckNumber(int number) {
        return StringUtil.formatCountWith0("", "%04d", number);
    }

    public static String getHumpName(String str) {
        boolean isDist = false;
        StringBuilder sbr = new StringBuilder();
        for (char char1 : str.toCharArray()) {
            if (char1 == '_') {
                isDist = true;
                continue;
            }
            sbr.append(isDist && 'a' <= char1 && 'z' >= char1 ? (char)(char1 - 32) : char1);
            isDist = false;
        }
        return sbr.toString();
    }

    public static String firstCharUpperCase(String str) {
        return str.substring(0, 1).toUpperCase().concat(str.substring(1));
    }

    public static String toHexString(String s, int length) {
        String result = Integer.toHexString(ConverterUtils.toInt(s)).toUpperCase();
        int resultLength = result.length();
        if (resultLength < length) {
            for (int i = 0; i < length - resultLength; ++i) {
                result = "0" + result;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.formatShortNumber(1888));
    }

    public static String toStringHex(String s) {
        return StringUtil.toString(Integer.parseInt(s, 16));
    }
}

