/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.conditions;

import com.fierhub.model.FierhubConfig;
import in.bottomhalf.common.models.DatabaseProperties;
import java.util.ArrayList;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class LoadFierhubConfigurationCondition {
    public void getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        FierhubConfig fierHubConfigInstance = FierhubConfig.getInstance();
        if (fierHubConfigInstance.isConfigurationCompleted()) {
            return;
        }
        Environment env = context.getEnvironment();
        Binder binder = Binder.get((Environment)env);
        try {
            BindResult fierhubResult = binder.bind("fierhub", FierhubConfig.class);
            FierhubConfig fierhubConfig = (FierhubConfig)fierhubResult.orElse(null);
            BindResult datasourceProperties = binder.bind("spring.datasource", DatabaseProperties.class);
            DatabaseProperties databaseProperties = (DatabaseProperties)datasourceProperties.orElse(null);
            if (fierhubConfig == null) {
                throw new Exception("\u26a0\ufe0f No fierhub configuration found in application.yml");
            }
            if (databaseProperties != null) {
                ArrayList<FierhubConfig.DatasourceModel> connections = new ArrayList<FierhubConfig.DatasourceModel>();
                FierhubConfig.DatasourceModel datasource = new FierhubConfig.DatasourceModel();
                datasource.setProperties(databaseProperties);
                datasource.setOrder(1);
                datasource.setName("default");
                connections.add(datasource);
                fierhubConfig.setConnections(connections);
            }
            fierHubConfigInstance.initialize(fierhubConfig);
            fierHubConfigInstance.setConfigurationCompleted(true);
            System.out.println("\u2705 FierHub configuration successfully loaded");
            return;
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to bind FierHub configuration: " + e.getMessage());
            return;
        }
    }
}

