/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.configures;

import com.fierhub.configures.RouteValidator;
import com.fierhub.database.service.DbManager;
import com.fierhub.database.utils.DbProcedureManager;
import com.fierhub.model.FierhubConfig;
import com.fierhub.service.JwtService;
import com.fierhub.service.RequestFilterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.context.annotation.RequestScope;

@AutoConfiguration
@ConditionalOnClass(value={RequestFilterService.class})
@ComponentScan(basePackages={"com.fierhub.*"})
public class AutoConfigureServices {
    @Bean
    @ConditionalOnMissingBean
    public RequestFilterService authService() {
        return new RequestFilterService();
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtService jwtService() {
        return new JwtService();
    }

    @Bean
    public RouteValidator filterRouteValidator() {
        return new RouteValidator();
    }

    @Bean
    public FierhubConfig fierHubConfig() {
        FierhubConfig fierhubConfig = FierhubConfig.getInstance();
        return fierhubConfig;
    }

    @Bean
    @RequestScope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    public DbProcedureManager dbProcedureManager(@Autowired FierhubConfig fierhubConfig) throws Exception {
        FierhubConfig.DatasourceModel con = fierhubConfig.getDefaultConnection();
        return new DbProcedureManager(con.getProperties());
    }

    @Bean
    @RequestScope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    public DbManager dbManager(@Autowired FierhubConfig fierhubConfig) throws Exception {
        FierhubConfig.DatasourceModel con = fierhubConfig.getDefaultConnection();
        return new DbManager(con.getProperties());
    }
}

